/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.hot_threads.HotThread;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class HotThreadsResponse
implements JsonpSerializable {
    private final List<HotThread> hotThreads;
    public static final JsonpDeserializer<HotThreadsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HotThreadsResponse::setupHotThreadsResponseDeserializer, Builder::build);

    public HotThreadsResponse(Builder builder) {
        this.hotThreads = ModelTypeHelper.unmodifiableNonNull(builder.hotThreads, "hot_threads");
    }

    public HotThreadsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<HotThread> hotThreads() {
        return this.hotThreads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hot_threads");
        generator.writeStartArray();
        for (HotThread item0 : this.hotThreads) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupHotThreadsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::hotThreads, JsonpDeserializer.arrayDeserializer(HotThread._DESERIALIZER), "hot_threads", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HotThreadsResponse> {
        private List<HotThread> hotThreads;

        public Builder hotThreads(List<HotThread> value) {
            this.hotThreads = value;
            return this;
        }

        public Builder hotThreads(HotThread ... value) {
            this.hotThreads = Arrays.asList(value);
            return this;
        }

        public Builder addHotThreads(HotThread value) {
            if (this.hotThreads == null) {
                this.hotThreads = new ArrayList<HotThread>();
            }
            this.hotThreads.add(value);
            return this;
        }

        public Builder hotThreads(Function<HotThread.Builder, ObjectBuilder<HotThread>> fn) {
            return this.hotThreads(fn.apply(new HotThread.Builder()).build());
        }

        public Builder addHotThreads(Function<HotThread.Builder, ObjectBuilder<HotThread>> fn) {
            return this.addHotThreads(fn.apply(new HotThread.Builder()).build());
        }

        @Override
        public HotThreadsResponse build() {
            return new HotThreadsResponse(this);
        }
    }
}

