/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ThreadType;
import co.elastic.clients.elasticsearch.nodes.HotThreadsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class HotThreadsRequest
extends RequestBase {
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final Boolean ignoreIdleThreads;
    @Nullable
    private final String interval;
    @Nullable
    private final Long snapshots;
    @Nullable
    private final Long threads;
    @Nullable
    private final ThreadType threadType;
    @Nullable
    private final String timeout;
    public static final Endpoint<HotThreadsRequest, HotThreadsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<HotThreadsRequest, HotThreadsResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/hot_threads");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/hot_threads");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/nodes");
            buf.append("/hotthreads");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/hotthreads");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/hotthreads");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/hotthreads");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/nodes");
            buf.append("/hot_threads");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/hot_threads");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ignoreIdleThreads != null) {
            params.put("ignore_idle_threads", String.valueOf(request.ignoreIdleThreads));
        }
        if (request.interval != null) {
            params.put("interval", request.interval);
        }
        if (request.snapshots != null) {
            params.put("snapshots", String.valueOf(request.snapshots));
        }
        if (request.threads != null) {
            params.put("threads", String.valueOf(request.threads));
        }
        if (request.threadType != null) {
            params.put("thread_type", request.threadType.toString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HotThreadsResponse._DESERIALIZER);

    public HotThreadsRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.ignoreIdleThreads = builder.ignoreIdleThreads;
        this.interval = builder.interval;
        this.snapshots = builder.snapshots;
        this.threads = builder.threads;
        this.threadType = builder.threadType;
        this.timeout = builder.timeout;
    }

    public HotThreadsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public Boolean ignoreIdleThreads() {
        return this.ignoreIdleThreads;
    }

    @Nullable
    public String interval() {
        return this.interval;
    }

    @Nullable
    public Long snapshots() {
        return this.snapshots;
    }

    @Nullable
    public Long threads() {
        return this.threads;
    }

    @Nullable
    public ThreadType threadType() {
        return this.threadType;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<HotThreadsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Boolean ignoreIdleThreads;
        @Nullable
        private String interval;
        @Nullable
        private Long snapshots;
        @Nullable
        private Long threads;
        @Nullable
        private ThreadType threadType;
        @Nullable
        private String timeout;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder ignoreIdleThreads(@Nullable Boolean value) {
            this.ignoreIdleThreads = value;
            return this;
        }

        public Builder interval(@Nullable String value) {
            this.interval = value;
            return this;
        }

        public Builder snapshots(@Nullable Long value) {
            this.snapshots = value;
            return this;
        }

        public Builder threads(@Nullable Long value) {
            this.threads = value;
            return this;
        }

        public Builder threadType(@Nullable ThreadType value) {
            this.threadType = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public HotThreadsRequest build() {
            return new HotThreadsRequest(this);
        }
    }
}

