/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Breaker
implements JsonpSerializable {
    private final String estimatedSize;
    private final long estimatedSizeInBytes;
    private final String limitSize;
    private final long limitSizeInBytes;
    private final float overhead;
    private final float tripped;
    public static final JsonpDeserializer<Breaker> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Breaker::setupBreakerDeserializer, Builder::build);

    public Breaker(Builder builder) {
        this.estimatedSize = Objects.requireNonNull(builder.estimatedSize, "estimated_size");
        this.estimatedSizeInBytes = Objects.requireNonNull(builder.estimatedSizeInBytes, "estimated_size_in_bytes");
        this.limitSize = Objects.requireNonNull(builder.limitSize, "limit_size");
        this.limitSizeInBytes = Objects.requireNonNull(builder.limitSizeInBytes, "limit_size_in_bytes");
        this.overhead = Objects.requireNonNull(builder.overhead, "overhead").floatValue();
        this.tripped = Objects.requireNonNull(builder.tripped, "tripped").floatValue();
    }

    public Breaker(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String estimatedSize() {
        return this.estimatedSize;
    }

    public long estimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    public String limitSize() {
        return this.limitSize;
    }

    public long limitSizeInBytes() {
        return this.limitSizeInBytes;
    }

    public float overhead() {
        return this.overhead;
    }

    public float tripped() {
        return this.tripped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("estimated_size");
        generator.write(this.estimatedSize);
        generator.writeKey("estimated_size_in_bytes");
        generator.write(this.estimatedSizeInBytes);
        generator.writeKey("limit_size");
        generator.write(this.limitSize);
        generator.writeKey("limit_size_in_bytes");
        generator.write(this.limitSizeInBytes);
        generator.writeKey("overhead");
        generator.write((double)this.overhead);
        generator.writeKey("tripped");
        generator.write((double)this.tripped);
    }

    protected static void setupBreakerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::estimatedSize, JsonpDeserializer.stringDeserializer(), "estimated_size", new String[0]);
        op.add(Builder::estimatedSizeInBytes, JsonpDeserializer.longDeserializer(), "estimated_size_in_bytes", new String[0]);
        op.add(Builder::limitSize, JsonpDeserializer.stringDeserializer(), "limit_size", new String[0]);
        op.add(Builder::limitSizeInBytes, JsonpDeserializer.longDeserializer(), "limit_size_in_bytes", new String[0]);
        op.add(Builder::overhead, JsonpDeserializer.floatDeserializer(), "overhead", new String[0]);
        op.add(Builder::tripped, JsonpDeserializer.floatDeserializer(), "tripped", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Breaker> {
        private String estimatedSize;
        private Long estimatedSizeInBytes;
        private String limitSize;
        private Long limitSizeInBytes;
        private Float overhead;
        private Float tripped;

        public Builder estimatedSize(String value) {
            this.estimatedSize = value;
            return this;
        }

        public Builder estimatedSizeInBytes(long value) {
            this.estimatedSizeInBytes = value;
            return this;
        }

        public Builder limitSize(String value) {
            this.limitSize = value;
            return this;
        }

        public Builder limitSizeInBytes(long value) {
            this.limitSizeInBytes = value;
            return this;
        }

        public Builder overhead(float value) {
            this.overhead = Float.valueOf(value);
            return this;
        }

        public Builder tripped(float value) {
            this.tripped = Float.valueOf(value);
            return this;
        }

        @Override
        public Breaker build() {
            return new Breaker(this);
        }
    }
}

