/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.elasticsearch.ml.info.AnomalyDetectors;
import co.elastic.clients.elasticsearch.ml.info.Datafeeds;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Defaults
implements JsonpSerializable {
    private final AnomalyDetectors anomalyDetectors;
    private final Datafeeds datafeeds;
    public static final JsonpDeserializer<Defaults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Defaults::setupDefaultsDeserializer, Builder::build);

    public Defaults(Builder builder) {
        this.anomalyDetectors = Objects.requireNonNull(builder.anomalyDetectors, "anomaly_detectors");
        this.datafeeds = Objects.requireNonNull(builder.datafeeds, "datafeeds");
    }

    public Defaults(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AnomalyDetectors anomalyDetectors() {
        return this.anomalyDetectors;
    }

    public Datafeeds datafeeds() {
        return this.datafeeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_detectors");
        this.anomalyDetectors.serialize(generator, mapper);
        generator.writeKey("datafeeds");
        this.datafeeds.serialize(generator, mapper);
    }

    protected static void setupDefaultsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::anomalyDetectors, AnomalyDetectors._DESERIALIZER, "anomaly_detectors", new String[0]);
        op.add(Builder::datafeeds, Datafeeds._DESERIALIZER, "datafeeds", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Defaults> {
        private AnomalyDetectors anomalyDetectors;
        private Datafeeds datafeeds;

        public Builder anomalyDetectors(AnomalyDetectors value) {
            this.anomalyDetectors = value;
            return this;
        }

        public Builder anomalyDetectors(Function<AnomalyDetectors.Builder, ObjectBuilder<AnomalyDetectors>> fn) {
            return this.anomalyDetectors(fn.apply(new AnomalyDetectors.Builder()).build());
        }

        public Builder datafeeds(Datafeeds value) {
            this.datafeeds = value;
            return this;
        }

        public Builder datafeeds(Function<Datafeeds.Builder, ObjectBuilder<Datafeeds>> fn) {
            return this.datafeeds(fn.apply(new Datafeeds.Builder()).build());
        }

        @Override
        public Defaults build() {
            return new Defaults(this);
        }
    }
}

