/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ConfusionMatrixPrediction
implements JsonpSerializable {
    private final String predictedClass;
    private final int count;
    public static final JsonpDeserializer<ConfusionMatrixPrediction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixPrediction::setupConfusionMatrixPredictionDeserializer, Builder::build);

    public ConfusionMatrixPrediction(Builder builder) {
        this.predictedClass = Objects.requireNonNull(builder.predictedClass, "predicted_class");
        this.count = Objects.requireNonNull(builder.count, "count");
    }

    public ConfusionMatrixPrediction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String predictedClass() {
        return this.predictedClass;
    }

    public int count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("predicted_class");
        generator.write(this.predictedClass);
        generator.writeKey("count");
        generator.write(this.count);
    }

    protected static void setupConfusionMatrixPredictionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::predictedClass, JsonpDeserializer.stringDeserializer(), "predicted_class", new String[0]);
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ConfusionMatrixPrediction> {
        private String predictedClass;
        private Integer count;

        public Builder predictedClass(String value) {
            this.predictedClass = value;
            return this;
        }

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        @Override
        public ConfusionMatrixPrediction build() {
            return new ConfusionMatrixPrediction(this);
        }
    }
}

