/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.AnalysisMemoryLimit;
import co.elastic.clients.elasticsearch.ml.Detector;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.elasticsearch.ml.PerPartitionCategorization;
import co.elastic.clients.elasticsearch.ml.UpdateJobResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateJobRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final Boolean allowLazyOpen;
    @Nullable
    private final AnalysisMemoryLimit analysisLimits;
    @Nullable
    private final String backgroundPersistInterval;
    @Nullable
    private final Map<String, JsonData> customSettings;
    @Nullable
    private final List<String> categorizationFilters;
    @Nullable
    private final String description;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final Long dailyModelSnapshotRetentionAfterDays;
    @Nullable
    private final Long modelSnapshotRetentionDays;
    @Nullable
    private final Long renormalizationWindowDays;
    @Nullable
    private final Long resultsRetentionDays;
    @Nullable
    private final List<String> groups;
    @Nullable
    private final List<Detector> detectors;
    @Nullable
    private final PerPartitionCategorization perPartitionCategorization;
    public static final JsonpDeserializer<UpdateJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateJobRequest::setupUpdateJobRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateJobRequest, UpdateJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateJobRequest, UpdateJobResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateJobResponse._DESERIALIZER);

    public UpdateJobRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.allowLazyOpen = builder.allowLazyOpen;
        this.analysisLimits = builder.analysisLimits;
        this.backgroundPersistInterval = builder.backgroundPersistInterval;
        this.customSettings = ModelTypeHelper.unmodifiable(builder.customSettings);
        this.categorizationFilters = ModelTypeHelper.unmodifiable(builder.categorizationFilters);
        this.description = builder.description;
        this.modelPlotConfig = builder.modelPlotConfig;
        this.dailyModelSnapshotRetentionAfterDays = builder.dailyModelSnapshotRetentionAfterDays;
        this.modelSnapshotRetentionDays = builder.modelSnapshotRetentionDays;
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsRetentionDays = builder.resultsRetentionDays;
        this.groups = ModelTypeHelper.unmodifiable(builder.groups);
        this.detectors = ModelTypeHelper.unmodifiable(builder.detectors);
        this.perPartitionCategorization = builder.perPartitionCategorization;
    }

    public UpdateJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    @Nullable
    public AnalysisMemoryLimit analysisLimits() {
        return this.analysisLimits;
    }

    @Nullable
    public String backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    @Nullable
    public Map<String, JsonData> customSettings() {
        return this.customSettings;
    }

    @Nullable
    public List<String> categorizationFilters() {
        return this.categorizationFilters;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public Long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    @Nullable
    public Long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    @Nullable
    public Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Nullable
    public List<String> groups() {
        return this.groups;
    }

    @Nullable
    public List<Detector> detectors() {
        return this.detectors;
    }

    @Nullable
    public PerPartitionCategorization perPartitionCategorization() {
        return this.perPartitionCategorization;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyOpen != null) {
            generator.writeKey("allow_lazy_open");
            generator.write(this.allowLazyOpen.booleanValue());
        }
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        if (this.backgroundPersistInterval != null) {
            generator.writeKey("background_persist_interval");
            generator.write(this.backgroundPersistInterval);
        }
        if (this.customSettings != null) {
            generator.writeKey("custom_settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.customSettings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.categorizationFilters != null) {
            generator.writeKey("categorization_filters");
            generator.writeStartArray();
            for (String string : this.categorizationFilters) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            generator.writeKey("daily_model_snapshot_retention_after_days");
            generator.write(this.dailyModelSnapshotRetentionAfterDays.longValue());
        }
        if (this.modelSnapshotRetentionDays != null) {
            generator.writeKey("model_snapshot_retention_days");
            generator.write(this.modelSnapshotRetentionDays.longValue());
        }
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays.longValue());
        }
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays.longValue());
        }
        if (this.groups != null) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String string : this.groups) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.detectors != null) {
            generator.writeKey("detectors");
            generator.writeStartArray();
            for (Detector detector : this.detectors) {
                detector.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.perPartitionCategorization != null) {
            generator.writeKey("per_partition_categorization");
            this.perPartitionCategorization.serialize(generator, mapper);
        }
    }

    protected static void setupUpdateJobRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open", new String[0]);
        op.add(Builder::analysisLimits, AnalysisMemoryLimit._DESERIALIZER, "analysis_limits", new String[0]);
        op.add(Builder::backgroundPersistInterval, JsonpDeserializer.stringDeserializer(), "background_persist_interval", new String[0]);
        op.add(Builder::customSettings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "custom_settings", new String[0]);
        op.add(Builder::categorizationFilters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "categorization_filters", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config", new String[0]);
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days", new String[0]);
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days", new String[0]);
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days", new String[0]);
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days", new String[0]);
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups", new String[0]);
        op.add(Builder::detectors, JsonpDeserializer.arrayDeserializer(Detector._DESERIALIZER), "detectors", new String[0]);
        op.add(Builder::perPartitionCategorization, PerPartitionCategorization._DESERIALIZER, "per_partition_categorization", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateJobRequest> {
        private String jobId;
        @Nullable
        private Boolean allowLazyOpen;
        @Nullable
        private AnalysisMemoryLimit analysisLimits;
        @Nullable
        private String backgroundPersistInterval;
        @Nullable
        private Map<String, JsonData> customSettings;
        @Nullable
        private List<String> categorizationFilters;
        @Nullable
        private String description;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private Long dailyModelSnapshotRetentionAfterDays;
        @Nullable
        private Long modelSnapshotRetentionDays;
        @Nullable
        private Long renormalizationWindowDays;
        @Nullable
        private Long resultsRetentionDays;
        @Nullable
        private List<String> groups;
        @Nullable
        private List<Detector> detectors;
        @Nullable
        private PerPartitionCategorization perPartitionCategorization;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder allowLazyOpen(@Nullable Boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public Builder analysisLimits(@Nullable AnalysisMemoryLimit value) {
            this.analysisLimits = value;
            return this;
        }

        public Builder analysisLimits(Function<AnalysisMemoryLimit.Builder, ObjectBuilder<AnalysisMemoryLimit>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisMemoryLimit.Builder()).build());
        }

        public Builder backgroundPersistInterval(@Nullable String value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public Builder customSettings(@Nullable Map<String, JsonData> value) {
            this.customSettings = value;
            return this;
        }

        public Builder putCustomSettings(String key, JsonData value) {
            if (this.customSettings == null) {
                this.customSettings = new HashMap<String, JsonData>();
            }
            this.customSettings.put(key, value);
            return this;
        }

        public Builder categorizationFilters(@Nullable List<String> value) {
            this.categorizationFilters = value;
            return this;
        }

        public Builder categorizationFilters(String ... value) {
            this.categorizationFilters = Arrays.asList(value);
            return this;
        }

        public Builder addCategorizationFilters(String value) {
            if (this.categorizationFilters == null) {
                this.categorizationFilters = new ArrayList<String>();
            }
            this.categorizationFilters.add(value);
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public Builder dailyModelSnapshotRetentionAfterDays(@Nullable Long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public Builder modelSnapshotRetentionDays(@Nullable Long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        public Builder groups(@Nullable List<String> value) {
            this.groups = value;
            return this;
        }

        public Builder groups(String ... value) {
            this.groups = Arrays.asList(value);
            return this;
        }

        public Builder addGroups(String value) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(value);
            return this;
        }

        public Builder detectors(@Nullable List<Detector> value) {
            this.detectors = value;
            return this;
        }

        public Builder detectors(Detector ... value) {
            this.detectors = Arrays.asList(value);
            return this;
        }

        public Builder addDetectors(Detector value) {
            if (this.detectors == null) {
                this.detectors = new ArrayList<Detector>();
            }
            this.detectors.add(value);
            return this;
        }

        public Builder detectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.detectors(fn.apply(new Detector.Builder()).build());
        }

        public Builder addDetectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.addDetectors(fn.apply(new Detector.Builder()).build());
        }

        public Builder perPartitionCategorization(@Nullable PerPartitionCategorization value) {
            this.perPartitionCategorization = value;
            return this;
        }

        public Builder perPartitionCategorization(Function<PerPartitionCategorization.Builder, ObjectBuilder<PerPartitionCategorization>> fn) {
            return this.perPartitionCategorization(fn.apply(new PerPartitionCategorization.Builder()).build());
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }
    }
}

