/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AppliesTo;
import co.elastic.clients.elasticsearch.ml.ConditionOperator;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RuleCondition
implements JsonpSerializable {
    private final AppliesTo appliesTo;
    private final ConditionOperator operator;
    private final double value;
    public static final JsonpDeserializer<RuleCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuleCondition::setupRuleConditionDeserializer, Builder::build);

    public RuleCondition(Builder builder) {
        this.appliesTo = Objects.requireNonNull(builder.appliesTo, "applies_to");
        this.operator = Objects.requireNonNull(builder.operator, "operator");
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public RuleCondition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AppliesTo appliesTo() {
        return this.appliesTo;
    }

    public ConditionOperator operator() {
        return this.operator;
    }

    public double value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("applies_to");
        this.appliesTo.serialize(generator, mapper);
        generator.writeKey("operator");
        this.operator.serialize(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
    }

    protected static void setupRuleConditionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::appliesTo, AppliesTo._DESERIALIZER, "applies_to", new String[0]);
        op.add(Builder::operator, ConditionOperator._DESERIALIZER, "operator", new String[0]);
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RuleCondition> {
        private AppliesTo appliesTo;
        private ConditionOperator operator;
        private Double value;

        public Builder appliesTo(AppliesTo value) {
            this.appliesTo = value;
            return this;
        }

        public Builder operator(ConditionOperator value) {
            this.operator = value;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        public RuleCondition build() {
            return new RuleCondition(this);
        }
    }
}

