/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.elasticsearch.ml.PutDataFrameAnalyticsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Boolean allowLazyStart;
    private final DataframeAnalysis analysis;
    @Nullable
    private final JsonValue analyzedFields;
    @Nullable
    private final String description;
    private final DataframeAnalyticsDestination dest;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final String modelMemoryLimit;
    private final DataframeAnalyticsSource source;
    public static final JsonpDeserializer<PutDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataFrameAnalyticsRequest::setupPutDataFrameAnalyticsRequestDeserializer, Builder::build);
    public static final Endpoint<PutDataFrameAnalyticsRequest, PutDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutDataFrameAnalyticsRequest, PutDataFrameAnalyticsResponse>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutDataFrameAnalyticsResponse._DESERIALIZER);

    public PutDataFrameAnalyticsRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.allowLazyStart = builder.allowLazyStart;
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.analyzedFields = builder.analyzedFields;
        this.description = builder.description;
        this.dest = Objects.requireNonNull(builder.dest, "dest");
        this.maxNumThreads = builder.maxNumThreads;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.source = Objects.requireNonNull(builder.source, "source");
    }

    public PutDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    public DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public JsonValue analyzedFields() {
        return this.analyzedFields;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    @Nullable
    public Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public DataframeAnalyticsSource source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart.booleanValue());
        }
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            generator.write(this.analyzedFields);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
    }

    protected static void setupPutDataFrameAnalyticsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start", new String[0]);
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::analyzedFields, JsonpDeserializer.jsonValueDeserializer(), "analyzed_fields", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutDataFrameAnalyticsRequest> {
        private String id;
        @Nullable
        private Boolean allowLazyStart;
        private DataframeAnalysis analysis;
        @Nullable
        private JsonValue analyzedFields;
        @Nullable
        private String description;
        private DataframeAnalyticsDestination dest;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private String modelMemoryLimit;
        private DataframeAnalyticsSource source;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public Builder analyzedFields(@Nullable JsonValue value) {
            this.analyzedFields = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder dest(DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        @Override
        public PutDataFrameAnalyticsRequest build() {
            return new PutDataFrameAnalyticsRequest(this);
        }
    }
}

