/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutCalendarJobResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class PutCalendarJobRequest
extends RequestBase {
    private final String calendarId;
    private final String jobId;
    public static final Endpoint<PutCalendarJobRequest, PutCalendarJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutCalendarJobRequest, PutCalendarJobResponse>(request -> "PUT", request -> {
        boolean _calendarId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/jobs");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, PutCalendarJobResponse._DESERIALIZER);

    public PutCalendarJobRequest(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
    }

    public PutCalendarJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    public String jobId() {
        return this.jobId;
    }

    public static class Builder
    implements ObjectBuilder<PutCalendarJobRequest> {
        private String calendarId;
        private String jobId;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        @Override
        public PutCalendarJobRequest build() {
            return new PutCalendarJobRequest(this);
        }
    }
}

