/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PreviewDataFrameAnalyticsResponse;
import co.elastic.clients.elasticsearch.ml.preview_data_frame_analytics.DataframePreviewConfig;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PreviewDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final DataframePreviewConfig config;
    public static final JsonpDeserializer<PreviewDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDataFrameAnalyticsRequest::setupPreviewDataFrameAnalyticsRequestDeserializer, Builder::build);
    public static final Endpoint<PreviewDataFrameAnalyticsRequest, PreviewDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PreviewDataFrameAnalyticsRequest, PreviewDataFrameAnalyticsResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_preview");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PreviewDataFrameAnalyticsResponse._DESERIALIZER);

    public PreviewDataFrameAnalyticsRequest(Builder builder) {
        this.id = builder.id;
        this.config = builder.config;
    }

    public PreviewDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public DataframePreviewConfig config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.config != null) {
            generator.writeKey("config");
            this.config.serialize(generator, mapper);
        }
    }

    protected static void setupPreviewDataFrameAnalyticsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::config, DataframePreviewConfig._DESERIALIZER, "config", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PreviewDataFrameAnalyticsRequest> {
        @Nullable
        private String id;
        @Nullable
        private DataframePreviewConfig config;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder config(@Nullable DataframePreviewConfig value) {
            this.config = value;
            return this;
        }

        public Builder config(Function<DataframePreviewConfig.Builder, ObjectBuilder<DataframePreviewConfig>> fn) {
            return this.config(fn.apply(new DataframePreviewConfig.Builder()).build());
        }

        @Override
        public PreviewDataFrameAnalyticsRequest build() {
            return new PreviewDataFrameAnalyticsRequest(this);
        }
    }
}

