/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class OutlierDetectionParameters
implements JsonpSerializable {
    @Nullable
    private final Boolean computeFeatureInfluence;
    @Nullable
    private final Double featureInfluenceThreshold;
    @Nullable
    private final String method;
    @Nullable
    private final Integer nNeighbors;
    @Nullable
    private final Double outlierFraction;
    @Nullable
    private final Boolean standardizationEnabled;
    public static final JsonpDeserializer<OutlierDetectionParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OutlierDetectionParameters::setupOutlierDetectionParametersDeserializer, Builder::build);

    public OutlierDetectionParameters(Builder builder) {
        this.computeFeatureInfluence = builder.computeFeatureInfluence;
        this.featureInfluenceThreshold = builder.featureInfluenceThreshold;
        this.method = builder.method;
        this.nNeighbors = builder.nNeighbors;
        this.outlierFraction = builder.outlierFraction;
        this.standardizationEnabled = builder.standardizationEnabled;
    }

    public OutlierDetectionParameters(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean computeFeatureInfluence() {
        return this.computeFeatureInfluence;
    }

    @Nullable
    public Double featureInfluenceThreshold() {
        return this.featureInfluenceThreshold;
    }

    @Nullable
    public String method() {
        return this.method;
    }

    @Nullable
    public Integer nNeighbors() {
        return this.nNeighbors;
    }

    @Nullable
    public Double outlierFraction() {
        return this.outlierFraction;
    }

    @Nullable
    public Boolean standardizationEnabled() {
        return this.standardizationEnabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.computeFeatureInfluence != null) {
            generator.writeKey("compute_feature_influence");
            generator.write(this.computeFeatureInfluence.booleanValue());
        }
        if (this.featureInfluenceThreshold != null) {
            generator.writeKey("feature_influence_threshold");
            generator.write(this.featureInfluenceThreshold.doubleValue());
        }
        if (this.method != null) {
            generator.writeKey("method");
            generator.write(this.method);
        }
        if (this.nNeighbors != null) {
            generator.writeKey("n_neighbors");
            generator.write(this.nNeighbors.intValue());
        }
        if (this.outlierFraction != null) {
            generator.writeKey("outlier_fraction");
            generator.write(this.outlierFraction.doubleValue());
        }
        if (this.standardizationEnabled != null) {
            generator.writeKey("standardization_enabled");
            generator.write(this.standardizationEnabled.booleanValue());
        }
    }

    protected static void setupOutlierDetectionParametersDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::computeFeatureInfluence, JsonpDeserializer.booleanDeserializer(), "compute_feature_influence", new String[0]);
        op.add(Builder::featureInfluenceThreshold, JsonpDeserializer.doubleDeserializer(), "feature_influence_threshold", new String[0]);
        op.add(Builder::method, JsonpDeserializer.stringDeserializer(), "method", new String[0]);
        op.add(Builder::nNeighbors, JsonpDeserializer.integerDeserializer(), "n_neighbors", new String[0]);
        op.add(Builder::outlierFraction, JsonpDeserializer.doubleDeserializer(), "outlier_fraction", new String[0]);
        op.add(Builder::standardizationEnabled, JsonpDeserializer.booleanDeserializer(), "standardization_enabled", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OutlierDetectionParameters> {
        @Nullable
        private Boolean computeFeatureInfluence;
        @Nullable
        private Double featureInfluenceThreshold;
        @Nullable
        private String method;
        @Nullable
        private Integer nNeighbors;
        @Nullable
        private Double outlierFraction;
        @Nullable
        private Boolean standardizationEnabled;

        public Builder computeFeatureInfluence(@Nullable Boolean value) {
            this.computeFeatureInfluence = value;
            return this;
        }

        public Builder featureInfluenceThreshold(@Nullable Double value) {
            this.featureInfluenceThreshold = value;
            return this;
        }

        public Builder method(@Nullable String value) {
            this.method = value;
            return this;
        }

        public Builder nNeighbors(@Nullable Integer value) {
            this.nNeighbors = value;
            return this;
        }

        public Builder outlierFraction(@Nullable Double value) {
            this.outlierFraction = value;
            return this;
        }

        public Builder standardizationEnabled(@Nullable Boolean value) {
            this.standardizationEnabled = value;
            return this;
        }

        @Override
        public OutlierDetectionParameters build() {
            return new OutlierDetectionParameters(this);
        }
    }
}

