/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class JobTimingStats
implements JsonpSerializable {
    private final double averageBucketProcessingTimeMs;
    private final long bucketCount;
    private final double exponentialAverageBucketProcessingTimeMs;
    private final double exponentialAverageBucketProcessingTimePerHourMs;
    private final String jobId;
    private final double totalBucketProcessingTimeMs;
    private final double maximumBucketProcessingTimeMs;
    private final double minimumBucketProcessingTimeMs;
    public static final JsonpDeserializer<JobTimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobTimingStats::setupJobTimingStatsDeserializer, Builder::build);

    public JobTimingStats(Builder builder) {
        this.averageBucketProcessingTimeMs = Objects.requireNonNull(builder.averageBucketProcessingTimeMs, "average_bucket_processing_time_ms");
        this.bucketCount = Objects.requireNonNull(builder.bucketCount, "bucket_count");
        this.exponentialAverageBucketProcessingTimeMs = Objects.requireNonNull(builder.exponentialAverageBucketProcessingTimeMs, "exponential_average_bucket_processing_time_ms");
        this.exponentialAverageBucketProcessingTimePerHourMs = Objects.requireNonNull(builder.exponentialAverageBucketProcessingTimePerHourMs, "exponential_average_bucket_processing_time_per_hour_ms");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.totalBucketProcessingTimeMs = Objects.requireNonNull(builder.totalBucketProcessingTimeMs, "total_bucket_processing_time_ms");
        this.maximumBucketProcessingTimeMs = Objects.requireNonNull(builder.maximumBucketProcessingTimeMs, "maximum_bucket_processing_time_ms");
        this.minimumBucketProcessingTimeMs = Objects.requireNonNull(builder.minimumBucketProcessingTimeMs, "minimum_bucket_processing_time_ms");
    }

    public JobTimingStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double averageBucketProcessingTimeMs() {
        return this.averageBucketProcessingTimeMs;
    }

    public long bucketCount() {
        return this.bucketCount;
    }

    public double exponentialAverageBucketProcessingTimeMs() {
        return this.exponentialAverageBucketProcessingTimeMs;
    }

    public double exponentialAverageBucketProcessingTimePerHourMs() {
        return this.exponentialAverageBucketProcessingTimePerHourMs;
    }

    public String jobId() {
        return this.jobId;
    }

    public double totalBucketProcessingTimeMs() {
        return this.totalBucketProcessingTimeMs;
    }

    public double maximumBucketProcessingTimeMs() {
        return this.maximumBucketProcessingTimeMs;
    }

    public double minimumBucketProcessingTimeMs() {
        return this.minimumBucketProcessingTimeMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("average_bucket_processing_time_ms");
        generator.write(this.averageBucketProcessingTimeMs);
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        generator.writeKey("exponential_average_bucket_processing_time_ms");
        generator.write(this.exponentialAverageBucketProcessingTimeMs);
        generator.writeKey("exponential_average_bucket_processing_time_per_hour_ms");
        generator.write(this.exponentialAverageBucketProcessingTimePerHourMs);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("total_bucket_processing_time_ms");
        generator.write(this.totalBucketProcessingTimeMs);
        generator.writeKey("maximum_bucket_processing_time_ms");
        generator.write(this.maximumBucketProcessingTimeMs);
        generator.writeKey("minimum_bucket_processing_time_ms");
        generator.write(this.minimumBucketProcessingTimeMs);
    }

    protected static void setupJobTimingStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::averageBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "average_bucket_processing_time_ms", new String[0]);
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count", new String[0]);
        op.add(Builder::exponentialAverageBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_bucket_processing_time_ms", new String[0]);
        op.add(Builder::exponentialAverageBucketProcessingTimePerHourMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_bucket_processing_time_per_hour_ms", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::totalBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "total_bucket_processing_time_ms", new String[0]);
        op.add(Builder::maximumBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "maximum_bucket_processing_time_ms", new String[0]);
        op.add(Builder::minimumBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "minimum_bucket_processing_time_ms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JobTimingStats> {
        private Double averageBucketProcessingTimeMs;
        private Long bucketCount;
        private Double exponentialAverageBucketProcessingTimeMs;
        private Double exponentialAverageBucketProcessingTimePerHourMs;
        private String jobId;
        private Double totalBucketProcessingTimeMs;
        private Double maximumBucketProcessingTimeMs;
        private Double minimumBucketProcessingTimeMs;

        public Builder averageBucketProcessingTimeMs(double value) {
            this.averageBucketProcessingTimeMs = value;
            return this;
        }

        public Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public Builder exponentialAverageBucketProcessingTimeMs(double value) {
            this.exponentialAverageBucketProcessingTimeMs = value;
            return this;
        }

        public Builder exponentialAverageBucketProcessingTimePerHourMs(double value) {
            this.exponentialAverageBucketProcessingTimePerHourMs = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder totalBucketProcessingTimeMs(double value) {
            this.totalBucketProcessingTimeMs = value;
            return this;
        }

        public Builder maximumBucketProcessingTimeMs(double value) {
            this.maximumBucketProcessingTimeMs = value;
            return this;
        }

        public Builder minimumBucketProcessingTimeMs(double value) {
            this.minimumBucketProcessingTimeMs = value;
            return this;
        }

        @Override
        public JobTimingStats build() {
            return new JobTimingStats(this);
        }
    }
}

