/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class JobStatistics
implements JsonpSerializable {
    private final double avg;
    private final double max;
    private final double min;
    private final double total;
    public static final JsonpDeserializer<JobStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobStatistics::setupJobStatisticsDeserializer, Builder::build);

    public JobStatistics(Builder builder) {
        this.avg = Objects.requireNonNull(builder.avg, "avg");
        this.max = Objects.requireNonNull(builder.max, "max");
        this.min = Objects.requireNonNull(builder.min, "min");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public JobStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double avg() {
        return this.avg;
    }

    public double max() {
        return this.max;
    }

    public double min() {
        return this.min;
    }

    public double total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg");
        generator.write(this.avg);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupJobStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::avg, JsonpDeserializer.doubleDeserializer(), "avg", new String[0]);
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max", new String[0]);
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min", new String[0]);
        op.add(Builder::total, JsonpDeserializer.doubleDeserializer(), "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JobStatistics> {
        private Double avg;
        private Double max;
        private Double min;
        private Double total;

        public Builder avg(double value) {
            this.avg = value;
            return this;
        }

        public Builder max(double value) {
            this.max = value;
            return this;
        }

        public Builder min(double value) {
            this.min = value;
            return this;
        }

        public Builder total(double value) {
            this.total = value;
            return this;
        }

        @Override
        public JobStatistics build() {
            return new JobStatistics(this);
        }
    }
}

