/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobBlockedReason;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class JobBlocked
implements JsonpSerializable {
    private final JobBlockedReason reason;
    @Nullable
    private final String taskId;
    public static final JsonpDeserializer<JobBlocked> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobBlocked::setupJobBlockedDeserializer, Builder::build);

    public JobBlocked(Builder builder) {
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.taskId = builder.taskId;
    }

    public JobBlocked(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JobBlockedReason reason() {
        return this.reason;
    }

    @Nullable
    public String taskId() {
        return this.taskId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        if (this.taskId != null) {
            generator.writeKey("task_id");
            generator.write(this.taskId);
        }
    }

    protected static void setupJobBlockedDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::reason, JobBlockedReason._DESERIALIZER, "reason", new String[0]);
        op.add(Builder::taskId, JsonpDeserializer.stringDeserializer(), "task_id", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JobBlocked> {
        private JobBlockedReason reason;
        @Nullable
        private String taskId;

        public Builder reason(JobBlockedReason value) {
            this.reason = value;
            return this;
        }

        public Builder taskId(@Nullable String value) {
            this.taskId = value;
            return this;
        }

        @Override
        public JobBlocked build() {
            return new JobBlocked(this);
        }
    }
}

