/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Influence
implements JsonpSerializable {
    private final String influencerFieldName;
    private final List<String> influencerFieldValues;
    public static final JsonpDeserializer<Influence> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Influence::setupInfluenceDeserializer, Builder::build);

    public Influence(Builder builder) {
        this.influencerFieldName = Objects.requireNonNull(builder.influencerFieldName, "influencer_field_name");
        this.influencerFieldValues = ModelTypeHelper.unmodifiableNonNull(builder.influencerFieldValues, "influencer_field_values");
    }

    public Influence(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String influencerFieldName() {
        return this.influencerFieldName;
    }

    public List<String> influencerFieldValues() {
        return this.influencerFieldValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("influencer_field_name");
        generator.write(this.influencerFieldName);
        generator.writeKey("influencer_field_values");
        generator.writeStartArray();
        for (String item0 : this.influencerFieldValues) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupInfluenceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::influencerFieldName, JsonpDeserializer.stringDeserializer(), "influencer_field_name", new String[0]);
        op.add(Builder::influencerFieldValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "influencer_field_values", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Influence> {
        private String influencerFieldName;
        private List<String> influencerFieldValues;

        public Builder influencerFieldName(String value) {
            this.influencerFieldName = value;
            return this;
        }

        public Builder influencerFieldValues(List<String> value) {
            this.influencerFieldValues = value;
            return this;
        }

        public Builder influencerFieldValues(String ... value) {
            this.influencerFieldValues = Arrays.asList(value);
            return this;
        }

        public Builder addInfluencerFieldValues(String value) {
            if (this.influencerFieldValues == null) {
                this.influencerFieldValues = new ArrayList<String>();
            }
            this.influencerFieldValues.add(value);
            return this;
        }

        @Override
        public Influence build() {
            return new Influence(this);
        }
    }
}

