/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Hyperparameters
implements JsonpSerializable {
    @Nullable
    private final Double alpha;
    @Nullable
    private final Double lambda;
    @Nullable
    private final Double gamma;
    @Nullable
    private final Double eta;
    @Nullable
    private final Double etaGrowthRatePerTree;
    @Nullable
    private final Double featureBagFraction;
    @Nullable
    private final Double downsampleFactor;
    @Nullable
    private final Integer maxAttemptsToAddTree;
    @Nullable
    private final Integer maxOptimizationRoundsPerHyperparameter;
    @Nullable
    private final Integer maxTrees;
    @Nullable
    private final Integer numFolds;
    @Nullable
    private final Integer numSplitsPerFeature;
    @Nullable
    private final Integer softTreeDepthLimit;
    @Nullable
    private final Double softTreeDepthTolerance;
    public static final JsonpDeserializer<Hyperparameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hyperparameters::setupHyperparametersDeserializer, Builder::build);

    public Hyperparameters(Builder builder) {
        this.alpha = builder.alpha;
        this.lambda = builder.lambda;
        this.gamma = builder.gamma;
        this.eta = builder.eta;
        this.etaGrowthRatePerTree = builder.etaGrowthRatePerTree;
        this.featureBagFraction = builder.featureBagFraction;
        this.downsampleFactor = builder.downsampleFactor;
        this.maxAttemptsToAddTree = builder.maxAttemptsToAddTree;
        this.maxOptimizationRoundsPerHyperparameter = builder.maxOptimizationRoundsPerHyperparameter;
        this.maxTrees = builder.maxTrees;
        this.numFolds = builder.numFolds;
        this.numSplitsPerFeature = builder.numSplitsPerFeature;
        this.softTreeDepthLimit = builder.softTreeDepthLimit;
        this.softTreeDepthTolerance = builder.softTreeDepthTolerance;
    }

    public Hyperparameters(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Double alpha() {
        return this.alpha;
    }

    @Nullable
    public Double lambda() {
        return this.lambda;
    }

    @Nullable
    public Double gamma() {
        return this.gamma;
    }

    @Nullable
    public Double eta() {
        return this.eta;
    }

    @Nullable
    public Double etaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    @Nullable
    public Double featureBagFraction() {
        return this.featureBagFraction;
    }

    @Nullable
    public Double downsampleFactor() {
        return this.downsampleFactor;
    }

    @Nullable
    public Integer maxAttemptsToAddTree() {
        return this.maxAttemptsToAddTree;
    }

    @Nullable
    public Integer maxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    @Nullable
    public Integer maxTrees() {
        return this.maxTrees;
    }

    @Nullable
    public Integer numFolds() {
        return this.numFolds;
    }

    @Nullable
    public Integer numSplitsPerFeature() {
        return this.numSplitsPerFeature;
    }

    @Nullable
    public Integer softTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    @Nullable
    public Double softTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write(this.alpha.doubleValue());
        }
        if (this.lambda != null) {
            generator.writeKey("lambda");
            generator.write(this.lambda.doubleValue());
        }
        if (this.gamma != null) {
            generator.writeKey("gamma");
            generator.write(this.gamma.doubleValue());
        }
        if (this.eta != null) {
            generator.writeKey("eta");
            generator.write(this.eta.doubleValue());
        }
        if (this.etaGrowthRatePerTree != null) {
            generator.writeKey("eta_growth_rate_per_tree");
            generator.write(this.etaGrowthRatePerTree.doubleValue());
        }
        if (this.featureBagFraction != null) {
            generator.writeKey("feature_bag_fraction");
            generator.write(this.featureBagFraction.doubleValue());
        }
        if (this.downsampleFactor != null) {
            generator.writeKey("downsample_factor");
            generator.write(this.downsampleFactor.doubleValue());
        }
        if (this.maxAttemptsToAddTree != null) {
            generator.writeKey("max_attempts_to_add_tree");
            generator.write(this.maxAttemptsToAddTree.intValue());
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            generator.writeKey("max_optimization_rounds_per_hyperparameter");
            generator.write(this.maxOptimizationRoundsPerHyperparameter.intValue());
        }
        if (this.maxTrees != null) {
            generator.writeKey("max_trees");
            generator.write(this.maxTrees.intValue());
        }
        if (this.numFolds != null) {
            generator.writeKey("num_folds");
            generator.write(this.numFolds.intValue());
        }
        if (this.numSplitsPerFeature != null) {
            generator.writeKey("num_splits_per_feature");
            generator.write(this.numSplitsPerFeature.intValue());
        }
        if (this.softTreeDepthLimit != null) {
            generator.writeKey("soft_tree_depth_limit");
            generator.write(this.softTreeDepthLimit.intValue());
        }
        if (this.softTreeDepthTolerance != null) {
            generator.writeKey("soft_tree_depth_tolerance");
            generator.write(this.softTreeDepthTolerance.doubleValue());
        }
    }

    protected static void setupHyperparametersDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::alpha, JsonpDeserializer.doubleDeserializer(), "alpha", new String[0]);
        op.add(Builder::lambda, JsonpDeserializer.doubleDeserializer(), "lambda", new String[0]);
        op.add(Builder::gamma, JsonpDeserializer.doubleDeserializer(), "gamma", new String[0]);
        op.add(Builder::eta, JsonpDeserializer.doubleDeserializer(), "eta", new String[0]);
        op.add(Builder::etaGrowthRatePerTree, JsonpDeserializer.doubleDeserializer(), "eta_growth_rate_per_tree", new String[0]);
        op.add(Builder::featureBagFraction, JsonpDeserializer.doubleDeserializer(), "feature_bag_fraction", new String[0]);
        op.add(Builder::downsampleFactor, JsonpDeserializer.doubleDeserializer(), "downsample_factor", new String[0]);
        op.add(Builder::maxAttemptsToAddTree, JsonpDeserializer.integerDeserializer(), "max_attempts_to_add_tree", new String[0]);
        op.add(Builder::maxOptimizationRoundsPerHyperparameter, JsonpDeserializer.integerDeserializer(), "max_optimization_rounds_per_hyperparameter", new String[0]);
        op.add(Builder::maxTrees, JsonpDeserializer.integerDeserializer(), "max_trees", new String[0]);
        op.add(Builder::numFolds, JsonpDeserializer.integerDeserializer(), "num_folds", new String[0]);
        op.add(Builder::numSplitsPerFeature, JsonpDeserializer.integerDeserializer(), "num_splits_per_feature", new String[0]);
        op.add(Builder::softTreeDepthLimit, JsonpDeserializer.integerDeserializer(), "soft_tree_depth_limit", new String[0]);
        op.add(Builder::softTreeDepthTolerance, JsonpDeserializer.doubleDeserializer(), "soft_tree_depth_tolerance", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Hyperparameters> {
        @Nullable
        private Double alpha;
        @Nullable
        private Double lambda;
        @Nullable
        private Double gamma;
        @Nullable
        private Double eta;
        @Nullable
        private Double etaGrowthRatePerTree;
        @Nullable
        private Double featureBagFraction;
        @Nullable
        private Double downsampleFactor;
        @Nullable
        private Integer maxAttemptsToAddTree;
        @Nullable
        private Integer maxOptimizationRoundsPerHyperparameter;
        @Nullable
        private Integer maxTrees;
        @Nullable
        private Integer numFolds;
        @Nullable
        private Integer numSplitsPerFeature;
        @Nullable
        private Integer softTreeDepthLimit;
        @Nullable
        private Double softTreeDepthTolerance;

        public Builder alpha(@Nullable Double value) {
            this.alpha = value;
            return this;
        }

        public Builder lambda(@Nullable Double value) {
            this.lambda = value;
            return this;
        }

        public Builder gamma(@Nullable Double value) {
            this.gamma = value;
            return this;
        }

        public Builder eta(@Nullable Double value) {
            this.eta = value;
            return this;
        }

        public Builder etaGrowthRatePerTree(@Nullable Double value) {
            this.etaGrowthRatePerTree = value;
            return this;
        }

        public Builder featureBagFraction(@Nullable Double value) {
            this.featureBagFraction = value;
            return this;
        }

        public Builder downsampleFactor(@Nullable Double value) {
            this.downsampleFactor = value;
            return this;
        }

        public Builder maxAttemptsToAddTree(@Nullable Integer value) {
            this.maxAttemptsToAddTree = value;
            return this;
        }

        public Builder maxOptimizationRoundsPerHyperparameter(@Nullable Integer value) {
            this.maxOptimizationRoundsPerHyperparameter = value;
            return this;
        }

        public Builder maxTrees(@Nullable Integer value) {
            this.maxTrees = value;
            return this;
        }

        public Builder numFolds(@Nullable Integer value) {
            this.numFolds = value;
            return this;
        }

        public Builder numSplitsPerFeature(@Nullable Integer value) {
            this.numSplitsPerFeature = value;
            return this;
        }

        public Builder softTreeDepthLimit(@Nullable Integer value) {
            this.softTreeDepthLimit = value;
            return this;
        }

        public Builder softTreeDepthTolerance(@Nullable Double value) {
            this.softTreeDepthTolerance = value;
            return this;
        }

        @Override
        public Hyperparameters build() {
            return new Hyperparameters(this);
        }
    }
}

