/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetJobsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetJobsRequest
extends RequestBase {
    @Nullable
    private final List<String> jobId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Boolean excludeGenerated;
    public static final Endpoint<GetJobsRequest, GetJobsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetJobsRequest, GetJobsResponse>(request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetJobsResponse._DESERIALIZER);

    public GetJobsRequest(Builder builder) {
        this.jobId = ModelTypeHelper.unmodifiable(builder.jobId);
        this.allowNoMatch = builder.allowNoMatch;
        this.allowNoJobs = builder.allowNoJobs;
        this.excludeGenerated = builder.excludeGenerated;
    }

    public GetJobsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    public static class Builder
    implements ObjectBuilder<GetJobsRequest> {
        @Nullable
        private List<String> jobId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Boolean excludeGenerated;

        public Builder jobId(@Nullable List<String> value) {
            this.jobId = value;
            return this;
        }

        public Builder jobId(String ... value) {
            this.jobId = Arrays.asList(value);
            return this;
        }

        public Builder addJobId(String value) {
            if (this.jobId == null) {
                this.jobId = new ArrayList<String>();
            }
            this.jobId.add(value);
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        @Override
        public GetJobsRequest build() {
            return new GetJobsRequest(this);
        }
    }
}

