/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetInfluencersResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetInfluencersRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final Boolean desc;
    @Nullable
    private final String end;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Double influencerScore;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final String sort;
    @Nullable
    private final String start;
    @Nullable
    private final Page page;
    public static final JsonpDeserializer<GetInfluencersRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetInfluencersRequest::setupGetInfluencersRequestDeserializer, Builder::build);
    public static final Endpoint<GetInfluencersRequest, GetInfluencersResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetInfluencersRequest, GetInfluencersResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/influencers");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.desc != null) {
            params.put("desc", String.valueOf(request.desc));
        }
        if (request.end != null) {
            params.put("end", request.end);
        }
        if (request.excludeInterim != null) {
            params.put("exclude_interim", String.valueOf(request.excludeInterim));
        }
        if (request.influencerScore != null) {
            params.put("influencer_score", String.valueOf(request.influencerScore));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.sort != null) {
            params.put("sort", request.sort);
        }
        if (request.start != null) {
            params.put("start", request.start);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetInfluencersResponse._DESERIALIZER);

    public GetInfluencersRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.desc = builder.desc;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.influencerScore = builder.influencerScore;
        this.from = builder.from;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
        this.page = builder.page;
    }

    public GetInfluencersRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean desc() {
        return this.desc;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Nullable
    public Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public Double influencerScore() {
        return this.influencerScore;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public String sort() {
        return this.sort;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public Page page() {
        return this.page;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetInfluencersRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetInfluencersRequest> {
        private String jobId;
        @Nullable
        private Boolean desc;
        @Nullable
        private String end;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Double influencerScore;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private String sort;
        @Nullable
        private String start;
        @Nullable
        private Page page;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public Builder influencerScore(@Nullable Double value) {
            this.influencerScore = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        @Override
        public GetInfluencersRequest build() {
            return new GetInfluencersRequest(this);
        }
    }
}

