/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetFiltersResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetFiltersRequest
extends RequestBase {
    @Nullable
    private final String filterId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetFiltersRequest, GetFiltersResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetFiltersRequest, GetFiltersResponse>(request -> "GET", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (request.filterId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetFiltersResponse._DESERIALIZER);

    public GetFiltersRequest(Builder builder) {
        this.filterId = builder.filterId;
        this.from = builder.from;
        this.size = builder.size;
    }

    public GetFiltersRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String filterId() {
        return this.filterId;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<GetFiltersRequest> {
        @Nullable
        private String filterId;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;

        public Builder filterId(@Nullable String value) {
            this.filterId = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GetFiltersRequest build() {
            return new GetFiltersRequest(this);
        }
    }
}

