/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCalendarsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetCalendarsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String calendarId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Page page;
    public static final JsonpDeserializer<GetCalendarsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarsRequest::setupGetCalendarsRequestDeserializer, Builder::build);
    public static final Endpoint<GetCalendarsRequest, GetCalendarsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetCalendarsRequest, GetCalendarsResponse>(request -> "POST", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (request.calendarId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetCalendarsResponse._DESERIALIZER);

    public GetCalendarsRequest(Builder builder) {
        this.calendarId = builder.calendarId;
        this.from = builder.from;
        this.size = builder.size;
        this.page = builder.page;
    }

    public GetCalendarsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Page page() {
        return this.page;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetCalendarsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetCalendarsRequest> {
        @Nullable
        private String calendarId;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Page page;

        public Builder calendarId(@Nullable String value) {
            this.calendarId = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        @Override
        public GetCalendarsRequest build() {
            return new GetCalendarsRequest(this);
        }
    }
}

