/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsFieldSelection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsMemoryEstimation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExplainDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final List<DataframeAnalyticsFieldSelection> fieldSelection;
    private final DataframeAnalyticsMemoryEstimation memoryEstimation;
    public static final JsonpDeserializer<ExplainDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainDataFrameAnalyticsResponse::setupExplainDataFrameAnalyticsResponseDeserializer, Builder::build);

    public ExplainDataFrameAnalyticsResponse(Builder builder) {
        this.fieldSelection = ModelTypeHelper.unmodifiableNonNull(builder.fieldSelection, "field_selection");
        this.memoryEstimation = Objects.requireNonNull(builder.memoryEstimation, "memory_estimation");
    }

    public ExplainDataFrameAnalyticsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<DataframeAnalyticsFieldSelection> fieldSelection() {
        return this.fieldSelection;
    }

    public DataframeAnalyticsMemoryEstimation memoryEstimation() {
        return this.memoryEstimation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field_selection");
        generator.writeStartArray();
        for (DataframeAnalyticsFieldSelection item0 : this.fieldSelection) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("memory_estimation");
        this.memoryEstimation.serialize(generator, mapper);
    }

    protected static void setupExplainDataFrameAnalyticsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fieldSelection, JsonpDeserializer.arrayDeserializer(DataframeAnalyticsFieldSelection._DESERIALIZER), "field_selection", new String[0]);
        op.add(Builder::memoryEstimation, DataframeAnalyticsMemoryEstimation._DESERIALIZER, "memory_estimation", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExplainDataFrameAnalyticsResponse> {
        private List<DataframeAnalyticsFieldSelection> fieldSelection;
        private DataframeAnalyticsMemoryEstimation memoryEstimation;

        public Builder fieldSelection(List<DataframeAnalyticsFieldSelection> value) {
            this.fieldSelection = value;
            return this;
        }

        public Builder fieldSelection(DataframeAnalyticsFieldSelection ... value) {
            this.fieldSelection = Arrays.asList(value);
            return this;
        }

        public Builder addFieldSelection(DataframeAnalyticsFieldSelection value) {
            if (this.fieldSelection == null) {
                this.fieldSelection = new ArrayList<DataframeAnalyticsFieldSelection>();
            }
            this.fieldSelection.add(value);
            return this;
        }

        public Builder fieldSelection(Function<DataframeAnalyticsFieldSelection.Builder, ObjectBuilder<DataframeAnalyticsFieldSelection>> fn) {
            return this.fieldSelection(fn.apply(new DataframeAnalyticsFieldSelection.Builder()).build());
        }

        public Builder addFieldSelection(Function<DataframeAnalyticsFieldSelection.Builder, ObjectBuilder<DataframeAnalyticsFieldSelection>> fn) {
            return this.addFieldSelection(fn.apply(new DataframeAnalyticsFieldSelection.Builder()).build());
        }

        public Builder memoryEstimation(DataframeAnalyticsMemoryEstimation value) {
            this.memoryEstimation = value;
            return this;
        }

        public Builder memoryEstimation(Function<DataframeAnalyticsMemoryEstimation.Builder, ObjectBuilder<DataframeAnalyticsMemoryEstimation>> fn) {
            return this.memoryEstimation(fn.apply(new DataframeAnalyticsMemoryEstimation.Builder()).build());
        }

        @Override
        public ExplainDataFrameAnalyticsResponse build() {
            return new ExplainDataFrameAnalyticsResponse(this);
        }
    }
}

