/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteTrainedModelAliasResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteTrainedModelAliasRequest
extends RequestBase {
    private final String modelAlias;
    private final String modelId;
    public static final Endpoint<DeleteTrainedModelAliasRequest, DeleteTrainedModelAliasResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteTrainedModelAliasRequest, DeleteTrainedModelAliasResponse>(request -> "DELETE", request -> {
        boolean _modelAlias = true;
        int _modelId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/model_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelAlias, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteTrainedModelAliasResponse._DESERIALIZER);

    public DeleteTrainedModelAliasRequest(Builder builder) {
        this.modelAlias = Objects.requireNonNull(builder.modelAlias, "model_alias");
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
    }

    public DeleteTrainedModelAliasRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelAlias() {
        return this.modelAlias;
    }

    public String modelId() {
        return this.modelId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteTrainedModelAliasRequest> {
        private String modelAlias;
        private String modelId;

        public Builder modelAlias(String value) {
            this.modelAlias = value;
            return this;
        }

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        public DeleteTrainedModelAliasRequest build() {
            return new DeleteTrainedModelAliasRequest(this);
        }
    }
}

