/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteModelSnapshotResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteModelSnapshotRequest
extends RequestBase {
    private final String jobId;
    private final String snapshotId;
    public static final Endpoint<DeleteModelSnapshotRequest, DeleteModelSnapshotResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteModelSnapshotRequest, DeleteModelSnapshotResponse>(request -> "DELETE", request -> {
        boolean _jobId = true;
        int _snapshotId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteModelSnapshotResponse._DESERIALIZER);

    public DeleteModelSnapshotRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.snapshotId = Objects.requireNonNull(builder.snapshotId, "snapshot_id");
    }

    public DeleteModelSnapshotRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteModelSnapshotRequest> {
        private String jobId;
        private String snapshotId;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        @Override
        public DeleteModelSnapshotRequest build() {
            return new DeleteModelSnapshotRequest(this);
        }
    }
}

