/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalyticsStatsMemoryUsage
implements JsonpSerializable {
    @Nullable
    private final Long memoryReestimateBytes;
    private final long peakUsageBytes;
    private final String status;
    @Nullable
    private final String timestamp;
    public static final JsonpDeserializer<DataframeAnalyticsStatsMemoryUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsStatsMemoryUsage::setupDataframeAnalyticsStatsMemoryUsageDeserializer, Builder::build);

    public DataframeAnalyticsStatsMemoryUsage(Builder builder) {
        this.memoryReestimateBytes = builder.memoryReestimateBytes;
        this.peakUsageBytes = Objects.requireNonNull(builder.peakUsageBytes, "peak_usage_bytes");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.timestamp = builder.timestamp;
    }

    public DataframeAnalyticsStatsMemoryUsage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Long memoryReestimateBytes() {
        return this.memoryReestimateBytes;
    }

    public long peakUsageBytes() {
        return this.peakUsageBytes;
    }

    public String status() {
        return this.status;
    }

    @Nullable
    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.memoryReestimateBytes != null) {
            generator.writeKey("memory_reestimate_bytes");
            generator.write(this.memoryReestimateBytes.longValue());
        }
        generator.writeKey("peak_usage_bytes");
        generator.write(this.peakUsageBytes);
        generator.writeKey("status");
        generator.write(this.status);
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
    }

    protected static void setupDataframeAnalyticsStatsMemoryUsageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::memoryReestimateBytes, JsonpDeserializer.longDeserializer(), "memory_reestimate_bytes", new String[0]);
        op.add(Builder::peakUsageBytes, JsonpDeserializer.longDeserializer(), "peak_usage_bytes", new String[0]);
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalyticsStatsMemoryUsage> {
        @Nullable
        private Long memoryReestimateBytes;
        private Long peakUsageBytes;
        private String status;
        @Nullable
        private String timestamp;

        public Builder memoryReestimateBytes(@Nullable Long value) {
            this.memoryReestimateBytes = value;
            return this;
        }

        public Builder peakUsageBytes(long value) {
            this.peakUsageBytes = value;
            return this;
        }

        public Builder status(String value) {
            this.status = value;
            return this;
        }

        public Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public DataframeAnalyticsStatsMemoryUsage build() {
            return new DataframeAnalyticsStatsMemoryUsage(this);
        }
    }
}

