/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.NodeAttributes;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStats;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsDataCounts;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsMemoryUsage;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsProgress;
import co.elastic.clients.elasticsearch.ml.DataframeState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalytics
implements JsonpSerializable {
    @Nullable
    private final DataframeAnalyticsStats analysisStats;
    @Nullable
    private final String assignmentExplanation;
    private final DataframeAnalyticsStatsDataCounts dataCounts;
    private final String id;
    private final DataframeAnalyticsStatsMemoryUsage memoryUsage;
    @Nullable
    private final NodeAttributes node;
    private final List<DataframeAnalyticsStatsProgress> progress;
    private final DataframeState state;
    public static final JsonpDeserializer<DataframeAnalytics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalytics::setupDataframeAnalyticsDeserializer, Builder::build);

    public DataframeAnalytics(Builder builder) {
        this.analysisStats = builder.analysisStats;
        this.assignmentExplanation = builder.assignmentExplanation;
        this.dataCounts = Objects.requireNonNull(builder.dataCounts, "data_counts");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.memoryUsage = Objects.requireNonNull(builder.memoryUsage, "memory_usage");
        this.node = builder.node;
        this.progress = ModelTypeHelper.unmodifiableNonNull(builder.progress, "progress");
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    public DataframeAnalytics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public DataframeAnalyticsStats analysisStats() {
        return this.analysisStats;
    }

    @Nullable
    public String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public DataframeAnalyticsStatsDataCounts dataCounts() {
        return this.dataCounts;
    }

    public String id() {
        return this.id;
    }

    public DataframeAnalyticsStatsMemoryUsage memoryUsage() {
        return this.memoryUsage;
    }

    @Nullable
    public NodeAttributes node() {
        return this.node;
    }

    public List<DataframeAnalyticsStatsProgress> progress() {
        return this.progress;
    }

    public DataframeState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysisStats != null) {
            generator.writeKey("analysis_stats");
            this.analysisStats.serialize(generator, mapper);
        }
        if (this.assignmentExplanation != null) {
            generator.writeKey("assignment_explanation");
            generator.write(this.assignmentExplanation);
        }
        generator.writeKey("data_counts");
        this.dataCounts.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("memory_usage");
        this.memoryUsage.serialize(generator, mapper);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        generator.writeKey("progress");
        generator.writeStartArray();
        for (DataframeAnalyticsStatsProgress item0 : this.progress) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    protected static void setupDataframeAnalyticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analysisStats, DataframeAnalyticsStats._DESERIALIZER, "analysis_stats", new String[0]);
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation", new String[0]);
        op.add(Builder::dataCounts, DataframeAnalyticsStatsDataCounts._DESERIALIZER, "data_counts", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::memoryUsage, DataframeAnalyticsStatsMemoryUsage._DESERIALIZER, "memory_usage", new String[0]);
        op.add(Builder::node, NodeAttributes._DESERIALIZER, "node", new String[0]);
        op.add(Builder::progress, JsonpDeserializer.arrayDeserializer(DataframeAnalyticsStatsProgress._DESERIALIZER), "progress", new String[0]);
        op.add(Builder::state, DataframeState._DESERIALIZER, "state", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalytics> {
        @Nullable
        private DataframeAnalyticsStats analysisStats;
        @Nullable
        private String assignmentExplanation;
        private DataframeAnalyticsStatsDataCounts dataCounts;
        private String id;
        private DataframeAnalyticsStatsMemoryUsage memoryUsage;
        @Nullable
        private NodeAttributes node;
        private List<DataframeAnalyticsStatsProgress> progress;
        private DataframeState state;

        public Builder analysisStats(@Nullable DataframeAnalyticsStats value) {
            this.analysisStats = value;
            return this;
        }

        public Builder analysisStats(Function<DataframeAnalyticsStats.Builder, ObjectBuilder<DataframeAnalyticsStats>> fn) {
            return this.analysisStats(fn.apply(new DataframeAnalyticsStats.Builder()).build());
        }

        public Builder assignmentExplanation(@Nullable String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public Builder dataCounts(DataframeAnalyticsStatsDataCounts value) {
            this.dataCounts = value;
            return this;
        }

        public Builder dataCounts(Function<DataframeAnalyticsStatsDataCounts.Builder, ObjectBuilder<DataframeAnalyticsStatsDataCounts>> fn) {
            return this.dataCounts(fn.apply(new DataframeAnalyticsStatsDataCounts.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder memoryUsage(DataframeAnalyticsStatsMemoryUsage value) {
            this.memoryUsage = value;
            return this;
        }

        public Builder memoryUsage(Function<DataframeAnalyticsStatsMemoryUsage.Builder, ObjectBuilder<DataframeAnalyticsStatsMemoryUsage>> fn) {
            return this.memoryUsage(fn.apply(new DataframeAnalyticsStatsMemoryUsage.Builder()).build());
        }

        public Builder node(@Nullable NodeAttributes value) {
            this.node = value;
            return this;
        }

        public Builder node(Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.node(fn.apply(new NodeAttributes.Builder()).build());
        }

        public Builder progress(List<DataframeAnalyticsStatsProgress> value) {
            this.progress = value;
            return this;
        }

        public Builder progress(DataframeAnalyticsStatsProgress ... value) {
            this.progress = Arrays.asList(value);
            return this;
        }

        public Builder addProgress(DataframeAnalyticsStatsProgress value) {
            if (this.progress == null) {
                this.progress = new ArrayList<DataframeAnalyticsStatsProgress>();
            }
            this.progress.add(value);
            return this;
        }

        public Builder progress(Function<DataframeAnalyticsStatsProgress.Builder, ObjectBuilder<DataframeAnalyticsStatsProgress>> fn) {
            return this.progress(fn.apply(new DataframeAnalyticsStatsProgress.Builder()).build());
        }

        public Builder addProgress(Function<DataframeAnalyticsStatsProgress.Builder, ObjectBuilder<DataframeAnalyticsStatsProgress>> fn) {
            return this.addProgress(fn.apply(new DataframeAnalyticsStatsProgress.Builder()).build());
        }

        public Builder state(DataframeState value) {
            this.state = value;
            return this;
        }

        @Override
        public DataframeAnalytics build() {
            return new DataframeAnalytics(this);
        }
    }
}

