/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalysisRegression
extends DataframeAnalysisBase
implements DataframeAnalysisVariant {
    @Nullable
    private final String lossFunction;
    @Nullable
    private final Double lossFunctionParameter;
    public static final JsonpDeserializer<DataframeAnalysisRegression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisRegression::setupDataframeAnalysisRegressionDeserializer, Builder::build);

    public DataframeAnalysisRegression(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.lossFunctionParameter = builder.lossFunctionParameter;
    }

    public DataframeAnalysisRegression(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "regression";
    }

    @Nullable
    public String lossFunction() {
        return this.lossFunction;
    }

    @Nullable
    public Double lossFunctionParameter() {
        return this.lossFunctionParameter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lossFunction != null) {
            generator.writeKey("loss_function");
            generator.write(this.lossFunction);
        }
        if (this.lossFunctionParameter != null) {
            generator.writeKey("loss_function_parameter");
            generator.write(this.lossFunctionParameter.doubleValue());
        }
    }

    protected static void setupDataframeAnalysisRegressionDeserializer(DelegatingDeserializer<Builder> op) {
        DataframeAnalysisBase.setupDataframeAnalysisBaseDeserializer(op);
        op.add(Builder::lossFunction, JsonpDeserializer.stringDeserializer(), "loss_function", new String[0]);
        op.add(Builder::lossFunctionParameter, JsonpDeserializer.doubleDeserializer(), "loss_function_parameter", new String[0]);
    }

    public static class Builder
    extends DataframeAnalysisBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeAnalysisRegression> {
        @Nullable
        private String lossFunction;
        @Nullable
        private Double lossFunctionParameter;

        public Builder lossFunction(@Nullable String value) {
            this.lossFunction = value;
            return this;
        }

        public Builder lossFunctionParameter(@Nullable Double value) {
            this.lossFunctionParameter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalysisRegression build() {
            return new DataframeAnalysisRegression(this);
        }
    }
}

