/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalysisClassification
extends DataframeAnalysisBase
implements DataframeAnalysisVariant {
    @Nullable
    private final String classAssignmentObjective;
    @Nullable
    private final Integer numTopClasses;
    public static final JsonpDeserializer<DataframeAnalysisClassification> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisClassification::setupDataframeAnalysisClassificationDeserializer, Builder::build);

    public DataframeAnalysisClassification(Builder builder) {
        super(builder);
        this.classAssignmentObjective = builder.classAssignmentObjective;
        this.numTopClasses = builder.numTopClasses;
    }

    public DataframeAnalysisClassification(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "classification";
    }

    @Nullable
    public String classAssignmentObjective() {
        return this.classAssignmentObjective;
    }

    @Nullable
    public Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.classAssignmentObjective != null) {
            generator.writeKey("class_assignment_objective");
            generator.write(this.classAssignmentObjective);
        }
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
    }

    protected static void setupDataframeAnalysisClassificationDeserializer(DelegatingDeserializer<Builder> op) {
        DataframeAnalysisBase.setupDataframeAnalysisBaseDeserializer(op);
        op.add(Builder::classAssignmentObjective, JsonpDeserializer.stringDeserializer(), "class_assignment_objective", new String[0]);
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes", new String[0]);
    }

    public static class Builder
    extends DataframeAnalysisBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeAnalysisClassification> {
        @Nullable
        private String classAssignmentObjective;
        @Nullable
        private Integer numTopClasses;

        public Builder classAssignmentObjective(@Nullable String value) {
            this.classAssignmentObjective = value;
            return this;
        }

        public Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalysisClassification build() {
            return new DataframeAnalysisClassification(this);
        }
    }
}

