/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DatafeedState;
import co.elastic.clients.elasticsearch.ml.DatafeedTimingStats;
import co.elastic.clients.elasticsearch.ml.DiscoveryNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DatafeedStats
implements JsonpSerializable {
    private final String assignmentExplanation;
    private final String datafeedId;
    private final DiscoveryNode node;
    private final DatafeedState state;
    private final DatafeedTimingStats timingStats;
    public static final JsonpDeserializer<DatafeedStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedStats::setupDatafeedStatsDeserializer, Builder::build);

    public DatafeedStats(Builder builder) {
        this.assignmentExplanation = Objects.requireNonNull(builder.assignmentExplanation, "assignment_explanation");
        this.datafeedId = Objects.requireNonNull(builder.datafeedId, "datafeed_id");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.timingStats = Objects.requireNonNull(builder.timingStats, "timing_stats");
    }

    public DatafeedStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public String datafeedId() {
        return this.datafeedId;
    }

    public DiscoveryNode node() {
        return this.node;
    }

    public DatafeedState state() {
        return this.state;
    }

    public DatafeedTimingStats timingStats() {
        return this.timingStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("assignment_explanation");
        generator.write(this.assignmentExplanation);
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("timing_stats");
        this.timingStats.serialize(generator, mapper);
    }

    protected static void setupDatafeedStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation", new String[0]);
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id", new String[0]);
        op.add(Builder::node, DiscoveryNode._DESERIALIZER, "node", new String[0]);
        op.add(Builder::state, DatafeedState._DESERIALIZER, "state", new String[0]);
        op.add(Builder::timingStats, DatafeedTimingStats._DESERIALIZER, "timing_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DatafeedStats> {
        private String assignmentExplanation;
        private String datafeedId;
        private DiscoveryNode node;
        private DatafeedState state;
        private DatafeedTimingStats timingStats;

        public Builder assignmentExplanation(String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder node(DiscoveryNode value) {
            this.node = value;
            return this;
        }

        public Builder node(Function<DiscoveryNode.Builder, ObjectBuilder<DiscoveryNode>> fn) {
            return this.node(fn.apply(new DiscoveryNode.Builder()).build());
        }

        public Builder state(DatafeedState value) {
            this.state = value;
            return this;
        }

        public Builder timingStats(DatafeedTimingStats value) {
            this.timingStats = value;
            return this;
        }

        public Builder timingStats(Function<DatafeedTimingStats.Builder, ObjectBuilder<DatafeedTimingStats>> fn) {
            return this.timingStats(fn.apply(new DatafeedTimingStats.Builder()).build());
        }

        @Override
        public DatafeedStats build() {
            return new DatafeedStats(this);
        }
    }
}

