/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license.get;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class LicenseInformation
implements JsonpSerializable {
    private final String expiryDate;
    private final String expiryDateInMillis;
    private final String issueDate;
    private final String issueDateInMillis;
    private final String issuedTo;
    private final String issuer;
    private final long maxNodes;
    @Nullable
    private final Integer maxResourceUnits;
    private final LicenseStatus status;
    private final LicenseType type;
    private final String uid;
    private final String startDateInMillis;
    public static final JsonpDeserializer<LicenseInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LicenseInformation::setupLicenseInformationDeserializer, Builder::build);

    public LicenseInformation(Builder builder) {
        this.expiryDate = Objects.requireNonNull(builder.expiryDate, "expiry_date");
        this.expiryDateInMillis = Objects.requireNonNull(builder.expiryDateInMillis, "expiry_date_in_millis");
        this.issueDate = Objects.requireNonNull(builder.issueDate, "issue_date");
        this.issueDateInMillis = Objects.requireNonNull(builder.issueDateInMillis, "issue_date_in_millis");
        this.issuedTo = Objects.requireNonNull(builder.issuedTo, "issued_to");
        this.issuer = Objects.requireNonNull(builder.issuer, "issuer");
        this.maxNodes = Objects.requireNonNull(builder.maxNodes, "max_nodes");
        this.maxResourceUnits = builder.maxResourceUnits;
        this.status = Objects.requireNonNull(builder.status, "status");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.uid = Objects.requireNonNull(builder.uid, "uid");
        this.startDateInMillis = Objects.requireNonNull(builder.startDateInMillis, "start_date_in_millis");
    }

    public LicenseInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String expiryDate() {
        return this.expiryDate;
    }

    public String expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public String issueDate() {
        return this.issueDate;
    }

    public String issueDateInMillis() {
        return this.issueDateInMillis;
    }

    public String issuedTo() {
        return this.issuedTo;
    }

    public String issuer() {
        return this.issuer;
    }

    public long maxNodes() {
        return this.maxNodes;
    }

    @Nullable
    public Integer maxResourceUnits() {
        return this.maxResourceUnits;
    }

    public LicenseStatus status() {
        return this.status;
    }

    public LicenseType type() {
        return this.type;
    }

    public String uid() {
        return this.uid;
    }

    public String startDateInMillis() {
        return this.startDateInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date");
        generator.write(this.expiryDate);
        generator.writeKey("expiry_date_in_millis");
        generator.write(this.expiryDateInMillis);
        generator.writeKey("issue_date");
        generator.write(this.issueDate);
        generator.writeKey("issue_date_in_millis");
        generator.write(this.issueDateInMillis);
        generator.writeKey("issued_to");
        generator.write(this.issuedTo);
        generator.writeKey("issuer");
        generator.write(this.issuer);
        generator.writeKey("max_nodes");
        generator.write(this.maxNodes);
        if (this.maxResourceUnits != null) {
            generator.writeKey("max_resource_units");
            generator.write(this.maxResourceUnits.intValue());
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
        generator.writeKey("start_date_in_millis");
        generator.write(this.startDateInMillis);
    }

    protected static void setupLicenseInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expiryDate, JsonpDeserializer.stringDeserializer(), "expiry_date", new String[0]);
        op.add(Builder::expiryDateInMillis, JsonpDeserializer.stringDeserializer(), "expiry_date_in_millis", new String[0]);
        op.add(Builder::issueDate, JsonpDeserializer.stringDeserializer(), "issue_date", new String[0]);
        op.add(Builder::issueDateInMillis, JsonpDeserializer.stringDeserializer(), "issue_date_in_millis", new String[0]);
        op.add(Builder::issuedTo, JsonpDeserializer.stringDeserializer(), "issued_to", new String[0]);
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer", new String[0]);
        op.add(Builder::maxNodes, JsonpDeserializer.longDeserializer(), "max_nodes", new String[0]);
        op.add(Builder::maxResourceUnits, JsonpDeserializer.integerDeserializer(), "max_resource_units", new String[0]);
        op.add(Builder::status, LicenseStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, LicenseType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid", new String[0]);
        op.add(Builder::startDateInMillis, JsonpDeserializer.stringDeserializer(), "start_date_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LicenseInformation> {
        private String expiryDate;
        private String expiryDateInMillis;
        private String issueDate;
        private String issueDateInMillis;
        private String issuedTo;
        private String issuer;
        private Long maxNodes;
        @Nullable
        private Integer maxResourceUnits;
        private LicenseStatus status;
        private LicenseType type;
        private String uid;
        private String startDateInMillis;

        public Builder expiryDate(String value) {
            this.expiryDate = value;
            return this;
        }

        public Builder expiryDateInMillis(String value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public Builder issueDate(String value) {
            this.issueDate = value;
            return this;
        }

        public Builder issueDateInMillis(String value) {
            this.issueDateInMillis = value;
            return this;
        }

        public Builder issuedTo(String value) {
            this.issuedTo = value;
            return this;
        }

        public Builder issuer(String value) {
            this.issuer = value;
            return this;
        }

        public Builder maxNodes(long value) {
            this.maxNodes = value;
            return this;
        }

        public Builder maxResourceUnits(@Nullable Integer value) {
            this.maxResourceUnits = value;
            return this;
        }

        public Builder status(LicenseStatus value) {
            this.status = value;
            return this;
        }

        public Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public Builder uid(String value) {
            this.uid = value;
            return this;
        }

        public Builder startDateInMillis(String value) {
            this.startDateInMillis = value;
            return this;
        }

        @Override
        public LicenseInformation build() {
            return new LicenseInformation(this);
        }
    }
}

