/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PostStartTrialResponse
extends AcknowledgedResponseBase {
    @Nullable
    private final String errorMessage;
    private final boolean acknowledged;
    private final boolean trialWasStarted;
    private final LicenseType type;
    public static final JsonpDeserializer<PostStartTrialResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostStartTrialResponse::setupPostStartTrialResponseDeserializer, Builder::build);

    public PostStartTrialResponse(Builder builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.acknowledged = Objects.requireNonNull(builder.acknowledged, "acknowledged");
        this.trialWasStarted = Objects.requireNonNull(builder.trialWasStarted, "trial_was_started");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public PostStartTrialResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean acknowledged() {
        return this.acknowledged;
    }

    public boolean trialWasStarted() {
        return this.trialWasStarted;
    }

    public LicenseType type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.errorMessage != null) {
            generator.writeKey("error_message");
            generator.write(this.errorMessage);
        }
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("trial_was_started");
        generator.write(this.trialWasStarted);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupPostStartTrialResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::errorMessage, JsonpDeserializer.stringDeserializer(), "error_message", new String[0]);
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged", new String[0]);
        op.add(Builder::trialWasStarted, JsonpDeserializer.booleanDeserializer(), "trial_was_started", new String[0]);
        op.add(Builder::type, LicenseType._DESERIALIZER, "type", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostStartTrialResponse> {
        @Nullable
        private String errorMessage;
        private Boolean acknowledged;
        private Boolean trialWasStarted;
        private LicenseType type;

        public Builder errorMessage(@Nullable String value) {
            this.errorMessage = value;
            return this;
        }

        @Override
        public Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public Builder trialWasStarted(boolean value) {
            this.trialWasStarted = value;
            return this;
        }

        public Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartTrialResponse build() {
            return new PostStartTrialResponse(this);
        }
    }
}

