/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.post.Acknowledgement;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PostResponse
implements JsonpSerializable {
    @Nullable
    private final Acknowledgement acknowledge;
    private final boolean acknowledged;
    private final LicenseStatus licenseStatus;
    public static final JsonpDeserializer<PostResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostResponse::setupPostResponseDeserializer, Builder::build);

    public PostResponse(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.acknowledged = Objects.requireNonNull(builder.acknowledged, "acknowledged");
        this.licenseStatus = Objects.requireNonNull(builder.licenseStatus, "license_status");
    }

    public PostResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Acknowledgement acknowledge() {
        return this.acknowledge;
    }

    public boolean acknowledged() {
        return this.acknowledged;
    }

    public LicenseStatus licenseStatus() {
        return this.licenseStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.acknowledge != null) {
            generator.writeKey("acknowledge");
            this.acknowledge.serialize(generator, mapper);
        }
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("license_status");
        this.licenseStatus.serialize(generator, mapper);
    }

    protected static void setupPostResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::acknowledge, Acknowledgement._DESERIALIZER, "acknowledge", new String[0]);
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged", new String[0]);
        op.add(Builder::licenseStatus, LicenseStatus._DESERIALIZER, "license_status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PostResponse> {
        @Nullable
        private Acknowledgement acknowledge;
        private Boolean acknowledged;
        private LicenseStatus licenseStatus;

        public Builder acknowledge(@Nullable Acknowledgement value) {
            this.acknowledge = value;
            return this;
        }

        public Builder acknowledge(Function<Acknowledgement.Builder, ObjectBuilder<Acknowledgement>> fn) {
            return this.acknowledge(fn.apply(new Acknowledgement.Builder()).build());
        }

        public Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public Builder licenseStatus(LicenseStatus value) {
            this.licenseStatus = value;
            return this;
        }

        @Override
        public PostResponse build() {
            return new PostResponse(this);
        }
    }
}

