/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.geo_ip_stats;

import co.elastic.clients.elasticsearch.ingest.geo_ip_stats.GeoIpNodeDatabaseName;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoIpNodeDatabases
implements JsonpSerializable {
    private final List<GeoIpNodeDatabaseName> databases;
    private final List<String> filesInTemp;
    public static final JsonpDeserializer<GeoIpNodeDatabases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpNodeDatabases::setupGeoIpNodeDatabasesDeserializer, Builder::build);

    public GeoIpNodeDatabases(Builder builder) {
        this.databases = ModelTypeHelper.unmodifiableNonNull(builder.databases, "databases");
        this.filesInTemp = ModelTypeHelper.unmodifiableNonNull(builder.filesInTemp, "files_in_temp");
    }

    public GeoIpNodeDatabases(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<GeoIpNodeDatabaseName> databases() {
        return this.databases;
    }

    public List<String> filesInTemp() {
        return this.filesInTemp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("databases");
        generator.writeStartArray();
        for (GeoIpNodeDatabaseName geoIpNodeDatabaseName : this.databases) {
            geoIpNodeDatabaseName.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("files_in_temp");
        generator.writeStartArray();
        for (String string : this.filesInTemp) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupGeoIpNodeDatabasesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::databases, JsonpDeserializer.arrayDeserializer(GeoIpNodeDatabaseName._DESERIALIZER), "databases", new String[0]);
        op.add(Builder::filesInTemp, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "files_in_temp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoIpNodeDatabases> {
        private List<GeoIpNodeDatabaseName> databases;
        private List<String> filesInTemp;

        public Builder databases(List<GeoIpNodeDatabaseName> value) {
            this.databases = value;
            return this;
        }

        public Builder databases(GeoIpNodeDatabaseName ... value) {
            this.databases = Arrays.asList(value);
            return this;
        }

        public Builder addDatabases(GeoIpNodeDatabaseName value) {
            if (this.databases == null) {
                this.databases = new ArrayList<GeoIpNodeDatabaseName>();
            }
            this.databases.add(value);
            return this;
        }

        public Builder databases(Function<GeoIpNodeDatabaseName.Builder, ObjectBuilder<GeoIpNodeDatabaseName>> fn) {
            return this.databases(fn.apply(new GeoIpNodeDatabaseName.Builder()).build());
        }

        public Builder addDatabases(Function<GeoIpNodeDatabaseName.Builder, ObjectBuilder<GeoIpNodeDatabaseName>> fn) {
            return this.addDatabases(fn.apply(new GeoIpNodeDatabaseName.Builder()).build());
        }

        public Builder filesInTemp(List<String> value) {
            this.filesInTemp = value;
            return this;
        }

        public Builder filesInTemp(String ... value) {
            this.filesInTemp = Arrays.asList(value);
            return this;
        }

        public Builder addFilesInTemp(String value) {
            if (this.filesInTemp == null) {
                this.filesInTemp = new ArrayList<String>();
            }
            this.filesInTemp.add(value);
            return this;
        }

        @Override
        public GeoIpNodeDatabases build() {
            return new GeoIpNodeDatabases(this);
        }
    }
}

