/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SplitProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Boolean preserveTrailing;
    private final String separator;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<SplitProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SplitProcessor::setupSplitProcessorDeserializer, Builder::build);

    public SplitProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.preserveTrailing = builder.preserveTrailing;
        this.separator = Objects.requireNonNull(builder.separator, "separator");
        this.targetField = builder.targetField;
    }

    public SplitProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "split";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public Boolean preserveTrailing() {
        return this.preserveTrailing;
    }

    public String separator() {
        return this.separator;
    }

    @Nullable
    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.preserveTrailing != null) {
            generator.writeKey("preserve_trailing");
            generator.write(this.preserveTrailing.booleanValue());
        }
        generator.writeKey("separator");
        generator.write(this.separator);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    protected static void setupSplitProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::preserveTrailing, JsonpDeserializer.booleanDeserializer(), "preserve_trailing", new String[0]);
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SplitProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Boolean preserveTrailing;
        private String separator;
        @Nullable
        private String targetField;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder preserveTrailing(@Nullable Boolean value) {
            this.preserveTrailing = value;
            return this;
        }

        public Builder separator(String value) {
            this.separator = value;
            return this;
        }

        public Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SplitProcessor build() {
            return new SplitProcessor(this);
        }
    }
}

