/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ingest.Pipeline;
import co.elastic.clients.elasticsearch.ingest.SimulateResponse;
import co.elastic.clients.elasticsearch.ingest.simulate.Document;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SimulateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean verbose;
    @Nullable
    private final List<Document> docs;
    @Nullable
    private final Pipeline pipeline;
    public static final JsonpDeserializer<SimulateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateRequest::setupSimulateRequestDeserializer, Builder::build);
    public static final Endpoint<SimulateRequest, SimulateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SimulateRequest, SimulateResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/_simulate");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_simulate");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateResponse._DESERIALIZER);

    public SimulateRequest(Builder builder) {
        this.id = builder.id;
        this.verbose = builder.verbose;
        this.docs = ModelTypeHelper.unmodifiable(builder.docs);
        this.pipeline = builder.pipeline;
    }

    public SimulateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean verbose() {
        return this.verbose;
    }

    @Nullable
    public List<Document> docs() {
        return this.docs;
    }

    @Nullable
    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docs != null) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Document item0 : this.docs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            this.pipeline.serialize(generator, mapper);
        }
    }

    protected static void setupSimulateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Document._DESERIALIZER), "docs", new String[0]);
        op.add(Builder::pipeline, Pipeline._DESERIALIZER, "pipeline", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SimulateRequest> {
        @Nullable
        private String id;
        @Nullable
        private Boolean verbose;
        @Nullable
        private List<Document> docs;
        @Nullable
        private Pipeline pipeline;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        public Builder docs(@Nullable List<Document> value) {
            this.docs = value;
            return this;
        }

        public Builder docs(Document ... value) {
            this.docs = Arrays.asList(value);
            return this;
        }

        public Builder addDocs(Document value) {
            if (this.docs == null) {
                this.docs = new ArrayList<Document>();
            }
            this.docs.add(value);
            return this;
        }

        public Builder docs(Function<Document.Builder, ObjectBuilder<Document>> fn) {
            return this.docs(fn.apply(new Document.Builder()).build());
        }

        public Builder addDocs(Function<Document.Builder, ObjectBuilder<Document>> fn) {
            return this.addDocs(fn.apply(new Document.Builder()).build());
        }

        public Builder pipeline(@Nullable Pipeline value) {
            this.pipeline = value;
            return this;
        }

        public Builder pipeline(Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipeline(fn.apply(new Pipeline.Builder()).build());
        }

        @Override
        public SimulateRequest build() {
            return new SimulateRequest(this);
        }
    }
}

