/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PipelineConfig
implements JsonpSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final Long version;
    private final List<Processor> processors;
    public static final JsonpDeserializer<PipelineConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineConfig::setupPipelineConfigDeserializer, Builder::build);

    public PipelineConfig(Builder builder) {
        this.description = builder.description;
        this.version = builder.version;
        this.processors = ModelTypeHelper.unmodifiableNonNull(builder.processors, "processors");
    }

    public PipelineConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    public List<Processor> processors() {
        return this.processors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        generator.writeKey("processors");
        generator.writeStartArray();
        for (Processor item0 : this.processors) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupPipelineConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PipelineConfig> {
        @Nullable
        private String description;
        @Nullable
        private Long version;
        private List<Processor> processors;

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder processors(List<Processor> value) {
            this.processors = value;
            return this;
        }

        public Builder processors(Processor ... value) {
            this.processors = Arrays.asList(value);
            return this;
        }

        public Builder addProcessors(Processor value) {
            if (this.processors == null) {
                this.processors = new ArrayList<Processor>();
            }
            this.processors.add(value);
            return this;
        }

        public Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build());
        }

        public Builder addProcessors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addProcessors(fn.apply(new Processor.Builder()).build());
        }

        @Override
        public PipelineConfig build() {
            return new PipelineConfig(this);
        }
    }
}

