/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GrokProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final Map<String, String> patternDefinitions;
    private final List<String> patterns;
    @Nullable
    private final Boolean traceMatch;
    public static final JsonpDeserializer<GrokProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrokProcessor::setupGrokProcessorDeserializer, Builder::build);

    public GrokProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.patternDefinitions = ModelTypeHelper.unmodifiableNonNull(builder.patternDefinitions, "pattern_definitions");
        this.patterns = ModelTypeHelper.unmodifiableNonNull(builder.patterns, "patterns");
        this.traceMatch = builder.traceMatch;
    }

    public GrokProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "grok";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public Map<String, String> patternDefinitions() {
        return this.patternDefinitions;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    @Nullable
    public Boolean traceMatch() {
        return this.traceMatch;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("pattern_definitions");
        generator.writeStartObject();
        for (Map.Entry<String, String> entry : this.patternDefinitions.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("patterns");
        generator.writeStartArray();
        for (String string : this.patterns) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.traceMatch != null) {
            generator.writeKey("trace_match");
            generator.write(this.traceMatch.booleanValue());
        }
    }

    protected static void setupGrokProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::patternDefinitions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "pattern_definitions", new String[0]);
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns", new String[0]);
        op.add(Builder::traceMatch, JsonpDeserializer.booleanDeserializer(), "trace_match", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GrokProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private Map<String, String> patternDefinitions;
        private List<String> patterns;
        @Nullable
        private Boolean traceMatch;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder patternDefinitions(Map<String, String> value) {
            this.patternDefinitions = value;
            return this;
        }

        public Builder putPatternDefinitions(String key, String value) {
            if (this.patternDefinitions == null) {
                this.patternDefinitions = new HashMap<String, String>();
            }
            this.patternDefinitions.put(key, value);
            return this;
        }

        public Builder patterns(List<String> value) {
            this.patterns = value;
            return this;
        }

        public Builder patterns(String ... value) {
            this.patterns = Arrays.asList(value);
            return this;
        }

        public Builder addPatterns(String value) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(value);
            return this;
        }

        public Builder traceMatch(@Nullable Boolean value) {
            this.traceMatch = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GrokProcessor build() {
            return new GrokProcessor(this);
        }
    }
}

