/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.geo_ip_stats.GeoIpDownloadStatistics;
import co.elastic.clients.elasticsearch.ingest.geo_ip_stats.GeoIpNodeDatabases;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoIpStatsResponse
implements JsonpSerializable {
    private final GeoIpDownloadStatistics stats;
    private final Map<String, GeoIpNodeDatabases> nodes;
    public static final JsonpDeserializer<GeoIpStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpStatsResponse::setupGeoIpStatsResponseDeserializer, Builder::build);

    public GeoIpStatsResponse(Builder builder) {
        this.stats = Objects.requireNonNull(builder.stats, "stats");
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public GeoIpStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public GeoIpDownloadStatistics stats() {
        return this.stats;
    }

    public Map<String, GeoIpNodeDatabases> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, GeoIpNodeDatabases> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGeoIpStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::stats, GeoIpDownloadStatistics._DESERIALIZER, "stats", new String[0]);
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(GeoIpNodeDatabases._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoIpStatsResponse> {
        private GeoIpDownloadStatistics stats;
        private Map<String, GeoIpNodeDatabases> nodes;

        public Builder stats(GeoIpDownloadStatistics value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<GeoIpDownloadStatistics.Builder, ObjectBuilder<GeoIpDownloadStatistics>> fn) {
            return this.stats(fn.apply(new GeoIpDownloadStatistics.Builder()).build());
        }

        public Builder nodes(Map<String, GeoIpNodeDatabases> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, GeoIpNodeDatabases value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, GeoIpNodeDatabases>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<GeoIpNodeDatabases.Builder, ObjectBuilder<GeoIpNodeDatabases>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new GeoIpNodeDatabases.Builder()).build()));
        }

        public Builder putNodes(String key, Function<GeoIpNodeDatabases.Builder, ObjectBuilder<GeoIpNodeDatabases>> fn) {
            return this.putNodes(key, fn.apply(new GeoIpNodeDatabases.Builder()).build());
        }

        @Override
        public GeoIpStatsResponse build() {
            return new GeoIpStatsResponse(this);
        }
    }
}

