/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoIpProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String databaseFile;
    private final String field;
    private final boolean firstOnly;
    private final boolean ignoreMissing;
    private final List<String> properties;
    private final String targetField;
    public static final JsonpDeserializer<GeoIpProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpProcessor::setupGeoIpProcessorDeserializer, Builder::build);

    public GeoIpProcessor(Builder builder) {
        super(builder);
        this.databaseFile = Objects.requireNonNull(builder.databaseFile, "database_file");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.firstOnly = Objects.requireNonNull(builder.firstOnly, "first_only");
        this.ignoreMissing = Objects.requireNonNull(builder.ignoreMissing, "ignore_missing");
        this.properties = ModelTypeHelper.unmodifiableNonNull(builder.properties, "properties");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public GeoIpProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geoip";
    }

    public String databaseFile() {
        return this.databaseFile;
    }

    public String field() {
        return this.field;
    }

    public boolean firstOnly() {
        return this.firstOnly;
    }

    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public List<String> properties() {
        return this.properties;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("database_file");
        generator.write(this.databaseFile);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("first_only");
        generator.write(this.firstOnly);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("properties");
        generator.writeStartArray();
        for (String item0 : this.properties) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupGeoIpProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::databaseFile, JsonpDeserializer.stringDeserializer(), "database_file", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::firstOnly, JsonpDeserializer.booleanDeserializer(), "first_only", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoIpProcessor> {
        private String databaseFile;
        private String field;
        private Boolean firstOnly;
        private Boolean ignoreMissing;
        private List<String> properties;
        private String targetField;

        public Builder databaseFile(String value) {
            this.databaseFile = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder firstOnly(boolean value) {
            this.firstOnly = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder properties(List<String> value) {
            this.properties = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = Arrays.asList(value);
            return this;
        }

        public Builder addProperties(String value) {
            if (this.properties == null) {
                this.properties = new ArrayList<String>();
            }
            this.properties.add(value);
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoIpProcessor build() {
            return new GeoIpProcessor(this);
        }
    }
}

