/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<String> formats;
    @Nullable
    private final String locale;
    @Nullable
    private final String targetField;
    @Nullable
    private final String timezone;
    public static final JsonpDeserializer<DateProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateProcessor::setupDateProcessorDeserializer, Builder::build);

    public DateProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.formats = ModelTypeHelper.unmodifiableNonNull(builder.formats, "formats");
        this.locale = builder.locale;
        this.targetField = builder.targetField;
        this.timezone = builder.timezone;
    }

    public DateProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "date";
    }

    public String field() {
        return this.field;
    }

    public List<String> formats() {
        return this.formats;
    }

    @Nullable
    public String locale() {
        return this.locale;
    }

    @Nullable
    public String targetField() {
        return this.targetField;
    }

    @Nullable
    public String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("formats");
        generator.writeStartArray();
        for (String item0 : this.formats) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.timezone != null) {
            generator.writeKey("timezone");
            generator.write(this.timezone);
        }
    }

    protected static void setupDateProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::formats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "formats", new String[0]);
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateProcessor> {
        private String field;
        private List<String> formats;
        @Nullable
        private String locale;
        @Nullable
        private String targetField;
        @Nullable
        private String timezone;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder formats(List<String> value) {
            this.formats = value;
            return this;
        }

        public Builder formats(String ... value) {
            this.formats = Arrays.asList(value);
            return this;
        }

        public Builder addFormats(String value) {
            if (this.formats == null) {
                this.formats = new ArrayList<String>();
            }
            this.formats.add(value);
            return this;
        }

        public Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        public Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public Builder timezone(@Nullable String value) {
            this.timezone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateProcessor build() {
            return new DateProcessor(this);
        }
    }
}

