/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.ShapeType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CircleProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final double errorDistance;
    private final String field;
    private final boolean ignoreMissing;
    private final ShapeType shapeType;
    private final String targetField;
    public static final JsonpDeserializer<CircleProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CircleProcessor::setupCircleProcessorDeserializer, Builder::build);

    public CircleProcessor(Builder builder) {
        super(builder);
        this.errorDistance = Objects.requireNonNull(builder.errorDistance, "error_distance");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = Objects.requireNonNull(builder.ignoreMissing, "ignore_missing");
        this.shapeType = Objects.requireNonNull(builder.shapeType, "shape_type");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public CircleProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "circle";
    }

    public double errorDistance() {
        return this.errorDistance;
    }

    public String field() {
        return this.field;
    }

    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public ShapeType shapeType() {
        return this.shapeType;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("error_distance");
        generator.write(this.errorDistance);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("shape_type");
        this.shapeType.serialize(generator, mapper);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupCircleProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::errorDistance, JsonpDeserializer.doubleDeserializer(), "error_distance", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::shapeType, ShapeType._DESERIALIZER, "shape_type", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CircleProcessor> {
        private Double errorDistance;
        private String field;
        private Boolean ignoreMissing;
        private ShapeType shapeType;
        private String targetField;

        public Builder errorDistance(double value) {
            this.errorDistance = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder shapeType(ShapeType value) {
            this.shapeType = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CircleProcessor build() {
            return new CircleProcessor(this);
        }
    }
}

