/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AttachmentProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Long indexedChars;
    @Nullable
    private final String indexedCharsField;
    @Nullable
    private final List<String> properties;
    @Nullable
    private final String targetField;
    @Nullable
    private final String resourceName;
    public static final JsonpDeserializer<AttachmentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AttachmentProcessor::setupAttachmentProcessorDeserializer, Builder::build);

    public AttachmentProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.indexedChars = builder.indexedChars;
        this.indexedCharsField = builder.indexedCharsField;
        this.properties = ModelTypeHelper.unmodifiable(builder.properties);
        this.targetField = builder.targetField;
        this.resourceName = builder.resourceName;
    }

    public AttachmentProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "attachment";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public Long indexedChars() {
        return this.indexedChars;
    }

    @Nullable
    public String indexedCharsField() {
        return this.indexedCharsField;
    }

    @Nullable
    public List<String> properties() {
        return this.properties;
    }

    @Nullable
    public String targetField() {
        return this.targetField;
    }

    @Nullable
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.indexedChars != null) {
            generator.writeKey("indexed_chars");
            generator.write(this.indexedChars.longValue());
        }
        if (this.indexedCharsField != null) {
            generator.writeKey("indexed_chars_field");
            generator.write(this.indexedCharsField);
        }
        if (this.properties != null) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.resourceName != null) {
            generator.writeKey("resource_name");
            generator.write(this.resourceName);
        }
    }

    protected static void setupAttachmentProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::indexedChars, JsonpDeserializer.longDeserializer(), "indexed_chars", new String[0]);
        op.add(Builder::indexedCharsField, JsonpDeserializer.stringDeserializer(), "indexed_chars_field", new String[0]);
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
        op.add(Builder::resourceName, JsonpDeserializer.stringDeserializer(), "resource_name", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AttachmentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Long indexedChars;
        @Nullable
        private String indexedCharsField;
        @Nullable
        private List<String> properties;
        @Nullable
        private String targetField;
        @Nullable
        private String resourceName;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder indexedChars(@Nullable Long value) {
            this.indexedChars = value;
            return this;
        }

        public Builder indexedCharsField(@Nullable String value) {
            this.indexedCharsField = value;
            return this;
        }

        public Builder properties(@Nullable List<String> value) {
            this.properties = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = Arrays.asList(value);
            return this;
        }

        public Builder addProperties(String value) {
            if (this.properties == null) {
                this.properties = new ArrayList<String>();
            }
            this.properties.add(value);
            return this;
        }

        public Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public Builder resourceName(@Nullable String value) {
            this.resourceName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AttachmentProcessor build() {
            return new AttachmentProcessor(this);
        }
    }
}

