/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardLease
implements JsonpSerializable {
    private final String id;
    private final int retainingSeqNo;
    private final long timestamp;
    private final String source;
    public static final JsonpDeserializer<ShardLease> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardLease::setupShardLeaseDeserializer, Builder::build);

    public ShardLease(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.retainingSeqNo = Objects.requireNonNull(builder.retainingSeqNo, "retaining_seq_no");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.source = Objects.requireNonNull(builder.source, "source");
    }

    public ShardLease(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public int retainingSeqNo() {
        return this.retainingSeqNo;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("retaining_seq_no");
        generator.write(this.retainingSeqNo);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupShardLeaseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::retainingSeqNo, JsonpDeserializer.integerDeserializer(), "retaining_seq_no", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardLease> {
        private String id;
        private Integer retainingSeqNo;
        private Long timestamp;
        private String source;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder retainingSeqNo(int value) {
            this.retainingSeqNo = value;
            return this;
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        public ShardLease build() {
            return new ShardLease(this);
        }
    }
}

