/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStore;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardStoreWrapper
implements JsonpSerializable {
    private final List<ShardStore> stores;
    public static final JsonpDeserializer<ShardStoreWrapper> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreWrapper::setupShardStoreWrapperDeserializer, Builder::build);

    public ShardStoreWrapper(Builder builder) {
        this.stores = ModelTypeHelper.unmodifiableNonNull(builder.stores, "stores");
    }

    public ShardStoreWrapper(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ShardStore> stores() {
        return this.stores;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stores");
        generator.writeStartArray();
        for (ShardStore item0 : this.stores) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupShardStoreWrapperDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::stores, JsonpDeserializer.arrayDeserializer(ShardStore._DESERIALIZER), "stores", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStoreWrapper> {
        private List<ShardStore> stores;

        public Builder stores(List<ShardStore> value) {
            this.stores = value;
            return this;
        }

        public Builder stores(ShardStore ... value) {
            this.stores = Arrays.asList(value);
            return this;
        }

        public Builder addStores(ShardStore value) {
            if (this.stores == null) {
                this.stores = new ArrayList<ShardStore>();
            }
            this.stores.add(value);
            return this;
        }

        public Builder stores(Function<ShardStore.Builder, ObjectBuilder<ShardStore>> fn) {
            return this.stores(fn.apply(new ShardStore.Builder()).build());
        }

        public Builder addStores(Function<ShardStore.Builder, ObjectBuilder<ShardStore>> fn) {
            return this.addStores(fn.apply(new ShardStore.Builder()).build());
        }

        @Override
        public ShardStoreWrapper build() {
            return new ShardStoreWrapper(this);
        }
    }
}

