/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.elasticsearch.indices.segments.ShardsSegment;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class IndexSegment
implements JsonpSerializable {
    private final Map<String, List<ShardsSegment>> shards;
    public static final JsonpDeserializer<IndexSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSegment::setupIndexSegmentDeserializer, Builder::build);

    public IndexSegment(Builder builder) {
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public IndexSegment(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, List<ShardsSegment>> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartObject();
        for (Map.Entry<String, List<ShardsSegment>> item0 : this.shards.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (ShardsSegment item1 : item0.getValue()) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupIndexSegmentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardsSegment._DESERIALIZER)), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexSegment> {
        private Map<String, List<ShardsSegment>> shards;

        public Builder shards(Map<String, List<ShardsSegment>> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, List<ShardsSegment> value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, List<ShardsSegment>>();
            }
            this.shards.put(key, value);
            return this;
        }

        @Override
        public IndexSegment build() {
            return new IndexSegment(this);
        }
    }
}

