/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ResolveIndexItem
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final List<String> aliases;
    private final List<String> attributes;
    @Nullable
    private final String dataStream;
    public static final JsonpDeserializer<ResolveIndexItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexItem::setupResolveIndexItemDeserializer, Builder::build);

    public ResolveIndexItem(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.dataStream = builder.dataStream;
    }

    public ResolveIndexItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public List<String> aliases() {
        return this.aliases;
    }

    public List<String> attributes() {
        return this.attributes;
    }

    @Nullable
    public String dataStream() {
        return this.dataStream;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("attributes");
        generator.writeStartArray();
        for (String item0 : this.attributes) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            generator.write(this.dataStream);
        }
    }

    protected static void setupResolveIndexItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases", new String[0]);
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ResolveIndexItem> {
        private String name;
        @Nullable
        private List<String> aliases;
        private List<String> attributes;
        @Nullable
        private String dataStream;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder aliases(@Nullable List<String> value) {
            this.aliases = value;
            return this;
        }

        public Builder aliases(String ... value) {
            this.aliases = Arrays.asList(value);
            return this;
        }

        public Builder addAliases(String value) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(value);
            return this;
        }

        public Builder attributes(List<String> value) {
            this.attributes = value;
            return this;
        }

        public Builder attributes(String ... value) {
            this.attributes = Arrays.asList(value);
            return this;
        }

        public Builder addAttributes(String value) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<String>();
            }
            this.attributes.add(value);
            return this;
        }

        public Builder dataStream(@Nullable String value) {
            this.dataStream = value;
            return this;
        }

        @Override
        public ResolveIndexItem build() {
            return new ResolveIndexItem(this);
        }
    }
}

