/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ResolveIndexDataStreamsItem
implements JsonpSerializable {
    private final String name;
    private final String timestampField;
    private final List<String> backingIndices;
    public static final JsonpDeserializer<ResolveIndexDataStreamsItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexDataStreamsItem::setupResolveIndexDataStreamsItemDeserializer, Builder::build);

    public ResolveIndexDataStreamsItem(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.timestampField = Objects.requireNonNull(builder.timestampField, "timestamp_field");
        this.backingIndices = ModelTypeHelper.unmodifiableNonNull(builder.backingIndices, "backing_indices");
    }

    public ResolveIndexDataStreamsItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public String timestampField() {
        return this.timestampField;
    }

    public List<String> backingIndices() {
        return this.backingIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("timestamp_field");
        generator.write(this.timestampField);
        generator.writeKey("backing_indices");
        generator.writeStartArray();
        for (String item0 : this.backingIndices) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupResolveIndexDataStreamsItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field", new String[0]);
        op.add(Builder::backingIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backing_indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ResolveIndexDataStreamsItem> {
        private String name;
        private String timestampField;
        private List<String> backingIndices;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder timestampField(String value) {
            this.timestampField = value;
            return this;
        }

        public Builder backingIndices(List<String> value) {
            this.backingIndices = value;
            return this;
        }

        public Builder backingIndices(String ... value) {
            this.backingIndices = Arrays.asList(value);
            return this;
        }

        public Builder addBackingIndices(String value) {
            if (this.backingIndices == null) {
                this.backingIndices = new ArrayList<String>();
            }
            this.backingIndices.add(value);
            return this;
        }

        @Override
        public ResolveIndexDataStreamsItem build() {
            return new ResolveIndexDataStreamsItem(this);
        }
    }
}

