/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.RecoveryIndexStatus;
import co.elastic.clients.elasticsearch.indices.recovery.RecoveryOrigin;
import co.elastic.clients.elasticsearch.indices.recovery.RecoveryStartStatus;
import co.elastic.clients.elasticsearch.indices.recovery.TranslogStatus;
import co.elastic.clients.elasticsearch.indices.recovery.VerifyIndex;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardRecovery
implements JsonpSerializable {
    private final long id;
    private final RecoveryIndexStatus index;
    private final boolean primary;
    private final RecoveryOrigin source;
    private final String stage;
    @Nullable
    private final RecoveryStartStatus start;
    @Nullable
    private final String startTime;
    private final String startTimeInMillis;
    @Nullable
    private final String stopTime;
    private final String stopTimeInMillis;
    private final RecoveryOrigin target;
    @Nullable
    private final String totalTime;
    private final String totalTimeInMillis;
    private final TranslogStatus translog;
    private final String type;
    private final VerifyIndex verifyIndex;
    public static final JsonpDeserializer<ShardRecovery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRecovery::setupShardRecoveryDeserializer, Builder::build);

    public ShardRecovery(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.primary = Objects.requireNonNull(builder.primary, "primary");
        this.source = Objects.requireNonNull(builder.source, "source");
        this.stage = Objects.requireNonNull(builder.stage, "stage");
        this.start = builder.start;
        this.startTime = builder.startTime;
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.stopTime = builder.stopTime;
        this.stopTimeInMillis = Objects.requireNonNull(builder.stopTimeInMillis, "stop_time_in_millis");
        this.target = Objects.requireNonNull(builder.target, "target");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
        this.translog = Objects.requireNonNull(builder.translog, "translog");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.verifyIndex = Objects.requireNonNull(builder.verifyIndex, "verify_index");
    }

    public ShardRecovery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long id() {
        return this.id;
    }

    public RecoveryIndexStatus index() {
        return this.index;
    }

    public boolean primary() {
        return this.primary;
    }

    public RecoveryOrigin source() {
        return this.source;
    }

    public String stage() {
        return this.stage;
    }

    @Nullable
    public RecoveryStartStatus start() {
        return this.start;
    }

    @Nullable
    public String startTime() {
        return this.startTime;
    }

    public String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public String stopTime() {
        return this.stopTime;
    }

    public String stopTimeInMillis() {
        return this.stopTimeInMillis;
    }

    public RecoveryOrigin target() {
        return this.target;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TranslogStatus translog() {
        return this.translog;
    }

    public String type() {
        return this.type;
    }

    public VerifyIndex verifyIndex() {
        return this.verifyIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index");
        this.index.serialize(generator, mapper);
        generator.writeKey("primary");
        generator.write(this.primary);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("stage");
        generator.write(this.stage);
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime);
        }
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.stopTime != null) {
            generator.writeKey("stop_time");
            generator.write(this.stopTime);
        }
        generator.writeKey("stop_time_in_millis");
        generator.write(this.stopTimeInMillis);
        generator.writeKey("target");
        this.target.serialize(generator, mapper);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        generator.writeKey("translog");
        this.translog.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("verify_index");
        this.verifyIndex.serialize(generator, mapper);
    }

    protected static void setupShardRecoveryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id", new String[0]);
        op.add(Builder::index, RecoveryIndexStatus._DESERIALIZER, "index", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::source, RecoveryOrigin._DESERIALIZER, "source", new String[0]);
        op.add(Builder::stage, JsonpDeserializer.stringDeserializer(), "stage", new String[0]);
        op.add(Builder::start, RecoveryStartStatus._DESERIALIZER, "start", new String[0]);
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::stopTime, JsonpDeserializer.stringDeserializer(), "stop_time", new String[0]);
        op.add(Builder::stopTimeInMillis, JsonpDeserializer.stringDeserializer(), "stop_time_in_millis", new String[0]);
        op.add(Builder::target, RecoveryOrigin._DESERIALIZER, "target", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis", new String[0]);
        op.add(Builder::translog, TranslogStatus._DESERIALIZER, "translog", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::verifyIndex, VerifyIndex._DESERIALIZER, "verify_index", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardRecovery> {
        private Long id;
        private RecoveryIndexStatus index;
        private Boolean primary;
        private RecoveryOrigin source;
        private String stage;
        @Nullable
        private RecoveryStartStatus start;
        @Nullable
        private String startTime;
        private String startTimeInMillis;
        @Nullable
        private String stopTime;
        private String stopTimeInMillis;
        private RecoveryOrigin target;
        @Nullable
        private String totalTime;
        private String totalTimeInMillis;
        private TranslogStatus translog;
        private String type;
        private VerifyIndex verifyIndex;

        public Builder id(long value) {
            this.id = value;
            return this;
        }

        public Builder index(RecoveryIndexStatus value) {
            this.index = value;
            return this;
        }

        public Builder index(Function<RecoveryIndexStatus.Builder, ObjectBuilder<RecoveryIndexStatus>> fn) {
            return this.index(fn.apply(new RecoveryIndexStatus.Builder()).build());
        }

        public Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public Builder source(RecoveryOrigin value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<RecoveryOrigin.Builder, ObjectBuilder<RecoveryOrigin>> fn) {
            return this.source(fn.apply(new RecoveryOrigin.Builder()).build());
        }

        public Builder stage(String value) {
            this.stage = value;
            return this;
        }

        public Builder start(@Nullable RecoveryStartStatus value) {
            this.start = value;
            return this;
        }

        public Builder start(Function<RecoveryStartStatus.Builder, ObjectBuilder<RecoveryStartStatus>> fn) {
            return this.start(fn.apply(new RecoveryStartStatus.Builder()).build());
        }

        public Builder startTime(@Nullable String value) {
            this.startTime = value;
            return this;
        }

        public Builder startTimeInMillis(String value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder stopTime(@Nullable String value) {
            this.stopTime = value;
            return this;
        }

        public Builder stopTimeInMillis(String value) {
            this.stopTimeInMillis = value;
            return this;
        }

        public Builder target(RecoveryOrigin value) {
            this.target = value;
            return this;
        }

        public Builder target(Function<RecoveryOrigin.Builder, ObjectBuilder<RecoveryOrigin>> fn) {
            return this.target(fn.apply(new RecoveryOrigin.Builder()).build());
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public Builder translog(TranslogStatus value) {
            this.translog = value;
            return this;
        }

        public Builder translog(Function<TranslogStatus.Builder, ObjectBuilder<TranslogStatus>> fn) {
            return this.translog(fn.apply(new TranslogStatus.Builder()).build());
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder verifyIndex(VerifyIndex value) {
            this.verifyIndex = value;
            return this;
        }

        public Builder verifyIndex(Function<VerifyIndex.Builder, ObjectBuilder<VerifyIndex>> fn) {
            return this.verifyIndex(fn.apply(new VerifyIndex.Builder()).build());
        }

        @Override
        public ShardRecovery build() {
            return new ShardRecovery(this);
        }
    }
}

