/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_stream;

import co.elastic.clients.elasticsearch.indices.DataStreamHealthStatus;
import co.elastic.clients.elasticsearch.indices.get_data_stream.IndicesGetDataStreamItemIndex;
import co.elastic.clients.elasticsearch.indices.get_data_stream.IndicesGetDataStreamItemTimestampField;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndicesGetDataStreamItem
implements JsonpSerializable {
    private final String name;
    private final IndicesGetDataStreamItemTimestampField timestampField;
    private final List<IndicesGetDataStreamItemIndex> indices;
    private final int generation;
    private final String template;
    private final boolean hidden;
    @Nullable
    private final Boolean system;
    private final DataStreamHealthStatus status;
    @Nullable
    private final String ilmPolicy;
    @Nullable
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<IndicesGetDataStreamItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesGetDataStreamItem::setupIndicesGetDataStreamItemDeserializer, Builder::build);

    public IndicesGetDataStreamItem(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.timestampField = Objects.requireNonNull(builder.timestampField, "timestamp_field");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.generation = Objects.requireNonNull(builder.generation, "generation");
        this.template = Objects.requireNonNull(builder.template, "template");
        this.hidden = Objects.requireNonNull(builder.hidden, "hidden");
        this.system = builder.system;
        this.status = Objects.requireNonNull(builder.status, "status");
        this.ilmPolicy = builder.ilmPolicy;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
    }

    public IndicesGetDataStreamItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public IndicesGetDataStreamItemTimestampField timestampField() {
        return this.timestampField;
    }

    public List<IndicesGetDataStreamItemIndex> indices() {
        return this.indices;
    }

    public int generation() {
        return this.generation;
    }

    public String template() {
        return this.template;
    }

    public boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public Boolean system() {
        return this.system;
    }

    public DataStreamHealthStatus status() {
        return this.status;
    }

    @Nullable
    public String ilmPolicy() {
        return this.ilmPolicy;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("timestamp_field");
        this.timestampField.serialize(generator, mapper);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesGetDataStreamItemIndex indicesGetDataStreamItemIndex : this.indices) {
            indicesGetDataStreamItemIndex.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("template");
        generator.write(this.template);
        generator.writeKey("hidden");
        generator.write(this.hidden);
        if (this.system != null) {
            generator.writeKey("system");
            generator.write(this.system.booleanValue());
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.ilmPolicy != null) {
            generator.writeKey("ilm_policy");
            generator.write(this.ilmPolicy);
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndicesGetDataStreamItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::timestampField, IndicesGetDataStreamItemTimestampField._DESERIALIZER, "timestamp_field", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesGetDataStreamItemIndex._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation", new String[0]);
        op.add(Builder::template, JsonpDeserializer.stringDeserializer(), "template", new String[0]);
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden", new String[0]);
        op.add(Builder::system, JsonpDeserializer.booleanDeserializer(), "system", new String[0]);
        op.add(Builder::status, DataStreamHealthStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::ilmPolicy, JsonpDeserializer.stringDeserializer(), "ilm_policy", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesGetDataStreamItem> {
        private String name;
        private IndicesGetDataStreamItemTimestampField timestampField;
        private List<IndicesGetDataStreamItemIndex> indices;
        private Integer generation;
        private String template;
        private Boolean hidden;
        @Nullable
        private Boolean system;
        private DataStreamHealthStatus status;
        @Nullable
        private String ilmPolicy;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder timestampField(IndicesGetDataStreamItemTimestampField value) {
            this.timestampField = value;
            return this;
        }

        public Builder timestampField(Function<IndicesGetDataStreamItemTimestampField.Builder, ObjectBuilder<IndicesGetDataStreamItemTimestampField>> fn) {
            return this.timestampField(fn.apply(new IndicesGetDataStreamItemTimestampField.Builder()).build());
        }

        public Builder indices(List<IndicesGetDataStreamItemIndex> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesGetDataStreamItemIndex ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesGetDataStreamItemIndex value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesGetDataStreamItemIndex>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesGetDataStreamItemIndex.Builder, ObjectBuilder<IndicesGetDataStreamItemIndex>> fn) {
            return this.indices(fn.apply(new IndicesGetDataStreamItemIndex.Builder()).build());
        }

        public Builder addIndices(Function<IndicesGetDataStreamItemIndex.Builder, ObjectBuilder<IndicesGetDataStreamItemIndex>> fn) {
            return this.addIndices(fn.apply(new IndicesGetDataStreamItemIndex.Builder()).build());
        }

        public Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public Builder template(String value) {
            this.template = value;
            return this;
        }

        public Builder hidden(boolean value) {
            this.hidden = value;
            return this;
        }

        public Builder system(@Nullable Boolean value) {
            this.system = value;
            return this;
        }

        public Builder status(DataStreamHealthStatus value) {
            this.status = value;
            return this;
        }

        public Builder ilmPolicy(@Nullable String value) {
            this.ilmPolicy = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        @Override
        public IndicesGetDataStreamItem build() {
            return new IndicesGetDataStreamItem(this);
        }
    }
}

