/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.elasticsearch.indices.analyze.ExplainAnalyzeToken;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AnalyzerDetail
implements JsonpSerializable {
    private final String name;
    private final List<ExplainAnalyzeToken> tokens;
    public static final JsonpDeserializer<AnalyzerDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzerDetail::setupAnalyzerDetailDeserializer, Builder::build);

    public AnalyzerDetail(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.tokens = ModelTypeHelper.unmodifiableNonNull(builder.tokens, "tokens");
    }

    public AnalyzerDetail(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public List<ExplainAnalyzeToken> tokens() {
        return this.tokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("tokens");
        generator.writeStartArray();
        for (ExplainAnalyzeToken item0 : this.tokens) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAnalyzerDetailDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(ExplainAnalyzeToken._DESERIALIZER), "tokens", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyzerDetail> {
        private String name;
        private List<ExplainAnalyzeToken> tokens;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder tokens(List<ExplainAnalyzeToken> value) {
            this.tokens = value;
            return this;
        }

        public Builder tokens(ExplainAnalyzeToken ... value) {
            this.tokens = Arrays.asList(value);
            return this;
        }

        public Builder addTokens(ExplainAnalyzeToken value) {
            if (this.tokens == null) {
                this.tokens = new ArrayList<ExplainAnalyzeToken>();
            }
            this.tokens.add(value);
            return this;
        }

        public Builder tokens(Function<ExplainAnalyzeToken.Builder, ObjectBuilder<ExplainAnalyzeToken>> fn) {
            return this.tokens(fn.apply(new ExplainAnalyzeToken.Builder()).build());
        }

        public Builder addTokens(Function<ExplainAnalyzeToken.Builder, ObjectBuilder<ExplainAnalyzeToken>> fn) {
            return this.addTokens(fn.apply(new ExplainAnalyzeToken.Builder()).build());
        }

        @Override
        public AnalyzerDetail build() {
            return new AnalyzerDetail(this);
        }
    }
}

