/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.elasticsearch.indices.analyze.AnalyzerDetail;
import co.elastic.clients.elasticsearch.indices.analyze.CharFilterDetail;
import co.elastic.clients.elasticsearch.indices.analyze.TokenDetail;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalyzeDetail
implements JsonpSerializable {
    @Nullable
    private final AnalyzerDetail analyzer;
    @Nullable
    private final List<CharFilterDetail> charfilters;
    private final boolean customAnalyzer;
    @Nullable
    private final List<TokenDetail> tokenfilters;
    @Nullable
    private final TokenDetail tokenizer;
    public static final JsonpDeserializer<AnalyzeDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeDetail::setupAnalyzeDetailDeserializer, Builder::build);

    public AnalyzeDetail(Builder builder) {
        this.analyzer = builder.analyzer;
        this.charfilters = ModelTypeHelper.unmodifiable(builder.charfilters);
        this.customAnalyzer = Objects.requireNonNull(builder.customAnalyzer, "custom_analyzer");
        this.tokenfilters = ModelTypeHelper.unmodifiable(builder.tokenfilters);
        this.tokenizer = builder.tokenizer;
    }

    public AnalyzeDetail(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AnalyzerDetail analyzer() {
        return this.analyzer;
    }

    @Nullable
    public List<CharFilterDetail> charfilters() {
        return this.charfilters;
    }

    public boolean customAnalyzer() {
        return this.customAnalyzer;
    }

    @Nullable
    public List<TokenDetail> tokenfilters() {
        return this.tokenfilters;
    }

    @Nullable
    public TokenDetail tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            this.analyzer.serialize(generator, mapper);
        }
        if (this.charfilters != null) {
            generator.writeKey("charfilters");
            generator.writeStartArray();
            for (CharFilterDetail charFilterDetail : this.charfilters) {
                charFilterDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("custom_analyzer");
        generator.write(this.customAnalyzer);
        if (this.tokenfilters != null) {
            generator.writeKey("tokenfilters");
            generator.writeStartArray();
            for (TokenDetail tokenDetail : this.tokenfilters) {
                tokenDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    protected static void setupAnalyzeDetailDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analyzer, AnalyzerDetail._DESERIALIZER, "analyzer", new String[0]);
        op.add(Builder::charfilters, JsonpDeserializer.arrayDeserializer(CharFilterDetail._DESERIALIZER), "charfilters", new String[0]);
        op.add(Builder::customAnalyzer, JsonpDeserializer.booleanDeserializer(), "custom_analyzer", new String[0]);
        op.add(Builder::tokenfilters, JsonpDeserializer.arrayDeserializer(TokenDetail._DESERIALIZER), "tokenfilters", new String[0]);
        op.add(Builder::tokenizer, TokenDetail._DESERIALIZER, "tokenizer", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyzeDetail> {
        @Nullable
        private AnalyzerDetail analyzer;
        @Nullable
        private List<CharFilterDetail> charfilters;
        private Boolean customAnalyzer;
        @Nullable
        private List<TokenDetail> tokenfilters;
        @Nullable
        private TokenDetail tokenizer;

        public Builder analyzer(@Nullable AnalyzerDetail value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzer(Function<AnalyzerDetail.Builder, ObjectBuilder<AnalyzerDetail>> fn) {
            return this.analyzer(fn.apply(new AnalyzerDetail.Builder()).build());
        }

        public Builder charfilters(@Nullable List<CharFilterDetail> value) {
            this.charfilters = value;
            return this;
        }

        public Builder charfilters(CharFilterDetail ... value) {
            this.charfilters = Arrays.asList(value);
            return this;
        }

        public Builder addCharfilters(CharFilterDetail value) {
            if (this.charfilters == null) {
                this.charfilters = new ArrayList<CharFilterDetail>();
            }
            this.charfilters.add(value);
            return this;
        }

        public Builder charfilters(Function<CharFilterDetail.Builder, ObjectBuilder<CharFilterDetail>> fn) {
            return this.charfilters(fn.apply(new CharFilterDetail.Builder()).build());
        }

        public Builder addCharfilters(Function<CharFilterDetail.Builder, ObjectBuilder<CharFilterDetail>> fn) {
            return this.addCharfilters(fn.apply(new CharFilterDetail.Builder()).build());
        }

        public Builder customAnalyzer(boolean value) {
            this.customAnalyzer = value;
            return this;
        }

        public Builder tokenfilters(@Nullable List<TokenDetail> value) {
            this.tokenfilters = value;
            return this;
        }

        public Builder tokenfilters(TokenDetail ... value) {
            this.tokenfilters = Arrays.asList(value);
            return this;
        }

        public Builder addTokenfilters(TokenDetail value) {
            if (this.tokenfilters == null) {
                this.tokenfilters = new ArrayList<TokenDetail>();
            }
            this.tokenfilters.add(value);
            return this;
        }

        public Builder tokenfilters(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenfilters(fn.apply(new TokenDetail.Builder()).build());
        }

        public Builder addTokenfilters(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.addTokenfilters(fn.apply(new TokenDetail.Builder()).build());
        }

        public Builder tokenizer(@Nullable TokenDetail value) {
            this.tokenizer = value;
            return this;
        }

        public Builder tokenizer(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenizer(fn.apply(new TokenDetail.Builder()).build());
        }

        @Override
        public AnalyzeDetail build() {
            return new AnalyzeDetail(this);
        }
    }
}

